/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.inventoryaccess.component;

import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.ComponentWrapper;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.i18n.AdventureComponentLocalizer;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.i18n.Languages;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.util.AdventureComponentUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.gson.GsonComponentSerializer;
import org.jetbrains.annotations.NotNull;

public class AdventureComponentWrapper
implements ComponentWrapper {
    public static final AdventureComponentWrapper EMPTY = new AdventureComponentWrapper((Component)Component.empty());
    private final Component component;

    public AdventureComponentWrapper(Component component) {
        this.component = component;
    }

    @Override
    @NotNull
    public String serializeToJson() {
        return (String)GsonComponentSerializer.gson().serialize(this.component);
    }

    @Override
    @NotNull
    public AdventureComponentWrapper localized(@NotNull String lang) {
        if (!Languages.getInstance().doesServerSideTranslations()) {
            return this;
        }
        return new AdventureComponentWrapper(AdventureComponentLocalizer.getInstance().localize(lang, this.component));
    }

    @Override
    @NotNull
    public AdventureComponentWrapper withoutPreFormatting() {
        return new AdventureComponentWrapper(AdventureComponentUtils.withoutPreFormatting(this.component));
    }

    @Override
    @NotNull
    public AdventureComponentWrapper clone() {
        try {
            return (AdventureComponentWrapper)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

