/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.inventoryaccess.component;

import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.ComponentWrapper;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.i18n.BungeeComponentLocalizer;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.i18n.Languages;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.util.BungeeComponentUtils;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.chat.ComponentSerializer;
import org.jetbrains.annotations.NotNull;

public class BungeeComponentWrapper
implements ComponentWrapper {
    public static final BungeeComponentWrapper EMPTY = new BungeeComponentWrapper(new BaseComponent[]{new TextComponent("")});
    private final BaseComponent[] components;

    public BungeeComponentWrapper(BaseComponent[] components) {
        this.components = components;
    }

    @Override
    @NotNull
    public BungeeComponentWrapper localized(@NotNull String lang) {
        if (!Languages.getInstance().doesServerSideTranslations()) {
            return this;
        }
        return new BungeeComponentWrapper(BungeeComponentLocalizer.getInstance().localize(lang, this.components));
    }

    @Override
    @NotNull
    public BungeeComponentWrapper withoutPreFormatting() {
        return new BungeeComponentWrapper(BungeeComponentUtils.withoutPreFormatting(this.components));
    }

    @Override
    @NotNull
    public String serializeToJson() {
        return ComponentSerializer.toString((BaseComponent[])this.components);
    }

    @Override
    @NotNull
    public BungeeComponentWrapper clone() {
        try {
            BungeeComponentWrapper clone = (BungeeComponentWrapper)super.clone();
            for (int i = 0; i < clone.components.length; ++i) {
                clone.components[i] = clone.components[i].duplicate();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

