/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.i18n;

import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.i18n.ComponentLocalizer;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.i18n.Languages;
import java.util.List;
import net.kyori.adventure.text.BuildableComponent;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TranslatableComponent;

public class AdventureComponentLocalizer
extends ComponentLocalizer<Component> {
    private static final AdventureComponentLocalizer INSTANCE = new AdventureComponentLocalizer();

    private AdventureComponentLocalizer() {
        super(Component::text);
    }

    public static AdventureComponentLocalizer getInstance() {
        return INSTANCE;
    }

    @Override
    public Component localize(String lang, Component component) {
        if (!(component instanceof BuildableComponent)) {
            throw new IllegalStateException("Component is not a BuildableComponent");
        }
        return this.localize(lang, (BuildableComponent)component);
    }

    @Override
    private <C extends BuildableComponent<C, B>, B extends ComponentBuilder<C, B>> BuildableComponent<?, ?> localize(String lang, BuildableComponent<C, B> component) {
        ComponentBuilder builder = component instanceof TranslatableComponent ? this.localizeTranslatable(lang, (TranslatableComponent)component).toBuilder() : component.toBuilder();
        builder.mapChildrenDeep(child -> {
            if (child instanceof TranslatableComponent) {
                return this.localizeTranslatable(lang, (TranslatableComponent)child);
            }
            return child;
        });
        return builder.build();
    }

    private BuildableComponent<?, ?> localizeTranslatable(String lang, TranslatableComponent component) {
        String formatString = Languages.getInstance().getFormatString(lang, component.key());
        if (formatString == null) {
            return component;
        }
        List<TranslatableComponent> children = this.decomposeFormatString(lang, formatString, component, component.args());
        return (BuildableComponent)Component.textOfChildren((ComponentLike[])((ComponentLike[])children.toArray(ComponentLike[]::new))).style(component.style());
    }
}

