/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.inventoryaccess.r22;

import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.ComponentWrapper;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.r22.InventoryUtilsImpl;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.NonNullList;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutSetSlot;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.ContainerAccess;
import net.minecraft.world.inventory.ContainerAnvil;
import net.minecraft.world.inventory.Containers;
import net.minecraft.world.level.World;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R3.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftInventoryAnvil;
import org.bukkit.craftbukkit.v1_21_R3.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R3.inventory.view.CraftAnvilView;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.AnvilInventory;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;

class AnvilInventoryImpl
extends ContainerAnvil
implements com.thexfactor117.levels.bukkit.libs.inventoryaccess.abstraction.inventory.AnvilInventory {
    private final List<Consumer<String>> renameHandlers;
    private final CraftAnvilView view;
    private final EntityPlayer player;
    private String text;
    private boolean open;

    public AnvilInventoryImpl(Player player, @NotNull ComponentWrapper title, List<Consumer<String>> renameHandlers) {
        this(((CraftPlayer)player).getHandle(), InventoryUtilsImpl.createNMSComponent(title), renameHandlers);
    }

    public AnvilInventoryImpl(EntityPlayer player, IChatBaseComponent title, List<Consumer<String>> renameHandlers) {
        super(player.nextContainerCounter(), player.gi(), ContainerAccess.a((World)player.dV(), (BlockPosition)new BlockPosition(0, 0, 0)));
        this.setTitle(title);
        this.renameHandlers = renameHandlers;
        this.player = player;
        CraftInventoryAnvil inventory = new CraftInventoryAnvil(this.q.getLocation(), this.s, (IInventory)this.t);
        this.view = new CraftAnvilView((HumanEntity)player.getBukkitEntity(), (AnvilInventory)inventory, (ContainerAnvil)this);
    }

    @Override
    public void open() {
        this.open = true;
        CraftEventFactory.callInventoryOpenEvent((EntityPlayer)this.player, (Container)this);
        this.player.cd = this;
        this.player.f.b((Packet)new PacketPlayOutOpenWindow(this.l, Containers.i, this.getTitle()));
        NonNullList itemsList = NonNullList.a((Object)net.minecraft.world.item.ItemStack.j, (Object[])new net.minecraft.world.item.ItemStack[]{this.getItem(0), this.getItem(1), this.getItem(2)});
        this.player.f.b((Packet)new PacketPlayOutWindowItems(this.getActiveWindowId(this.player), this.k(), itemsList, net.minecraft.world.item.ItemStack.j));
        this.player.a((Container)this);
    }

    public void sendItem(int slot) {
        this.player.f.b((Packet)new PacketPlayOutSetSlot(this.getActiveWindowId(this.player), this.k(), slot, this.getItem(slot)));
    }

    public void setItem(int slot, net.minecraft.world.item.ItemStack item) {
        if (slot < 2) {
            this.s.a(slot, item);
        } else {
            this.t.a(0, item);
        }
        if (this.open) {
            this.sendItem(slot);
        }
    }

    private net.minecraft.world.item.ItemStack getItem(int slot) {
        if (slot < 2) {
            return this.s.a(slot);
        }
        return this.t.a(0);
    }

    private int getActiveWindowId(EntityPlayer player) {
        Container container = player.cd;
        return container == null ? -1 : container.l;
    }

    @Override
    public void setItem(int slot, ItemStack itemStack) {
        this.setItem(slot, CraftItemStack.asNMSCopy((ItemStack)itemStack));
    }

    @Override
    @NotNull
    public Inventory getBukkitInventory() {
        return this.view.getTopInventory();
    }

    @Override
    public String getRenameText() {
        return this.text;
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    public CraftAnvilView getBukkitView() {
        return this.view;
    }

    public boolean b(EntityHuman player) {
        return true;
    }

    public boolean a(String s) {
        this.text = s;
        if (this.renameHandlers != null) {
            this.renameHandlers.forEach(handler -> handler.accept(s));
        }
        this.sendItem(2);
        return false;
    }

    public void a(EntityHuman player) {
        this.open = false;
    }

    protected void a(EntityHuman player, IInventory container) {
        this.open = false;
    }

    public void l() {
    }
}

