/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.inventoryaccess.r23;

import com.thexfactor117.levels.bukkit.libs.inventoryaccess.abstraction.util.InventoryUtils;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.ComponentWrapper;
import java.util.List;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundBundlePacket;
import net.minecraft.network.protocol.game.PacketPlayOutOpenWindow;
import net.minecraft.network.protocol.game.PacketPlayOutWindowItems;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.world.IInventory;
import net.minecraft.world.ITileInventory;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.inventory.Container;
import net.minecraft.world.inventory.Containers;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.craftbukkit.v1_21_R4.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftContainer;
import org.bukkit.craftbukkit.v1_21_R4.inventory.CraftInventory;
import org.bukkit.craftbukkit.v1_21_R4.util.CraftChatMessage;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class InventoryUtilsImpl
implements InventoryUtils {
    InventoryUtilsImpl() {
    }

    public static IChatBaseComponent createNMSComponent(ComponentWrapper component) {
        if (component == null) {
            return null;
        }
        return CraftChatMessage.fromJSON((String)component.serializeToJson());
    }

    public static int getActiveWindowId(EntityPlayer player) {
        Container container = player.bR;
        return container == null ? -1 : container.l;
    }

    @Override
    public void openCustomInventory(@NotNull Player player, @NotNull Inventory inventory) {
        this.openCustomInventory(player, inventory, null);
    }

    @Override
    public void openCustomInventory(@NotNull Player player, @NotNull Inventory inventory, @Nullable ComponentWrapper title) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Containers menuType = CraftContainer.getNotchInventoryType((Inventory)inventory);
        if (serverPlayer.f != null) {
            CraftContainer menu = new CraftContainer(inventory, (EntityHuman)serverPlayer, serverPlayer.nextContainerCounter());
            if ((menu = CraftEventFactory.callInventoryOpenEvent((EntityPlayer)serverPlayer, (Container)menu)) != null) {
                IInventory container = ((CraftInventory)inventory).getInventory();
                IChatBaseComponent titleComponent = title == null ? (container instanceof ITileInventory ? ((ITileInventory)container).P_() : CraftChatMessage.fromString((String)menu.getBukkitView().getTitle())[0]) : InventoryUtilsImpl.createNMSComponent(title);
                menu.checkReachable = false;
                serverPlayer.f.b((Packet)new PacketPlayOutOpenWindow(menu.l, menuType, titleComponent));
                serverPlayer.bR = menu;
                serverPlayer.a((Container)menu);
            }
        }
    }

    @Override
    public void updateOpenInventoryTitle(@NotNull Player player, @NotNull ComponentWrapper title) {
        EntityPlayer serverPlayer = ((CraftPlayer)player).getHandle();
        Container menu = serverPlayer.bR;
        PacketPlayOutOpenWindow open = new PacketPlayOutOpenWindow(menu.l, menu.a(), InventoryUtilsImpl.createNMSComponent(title));
        PacketPlayOutWindowItems content = new PacketPlayOutWindowItems(menu.l, menu.k(), (List)menu.c(), menu.g());
        ClientboundBundlePacket bundle = new ClientboundBundlePacket(List.of(open, content));
        serverPlayer.f.b((Packet)bundle);
    }

    @Override
    @Nullable
    public ItemStack getItemStackFromView(@NotNull InventoryView view, int slot) {
        return view.getItem(slot);
    }
}

