/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.inventoryaccess.r24;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.abstraction.util.ItemUtils;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.ComponentWrapper;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.r24.InventoryUtilsImpl;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.util.ReflectionRegistry;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.util.ReflectionUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.nbt.DynamicOpsNBT;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.datafix.DataConverterRegistry;
import net.minecraft.util.datafix.fixes.DataConverterTypes;
import org.bukkit.craftbukkit.v1_21_R5.CraftRegistry;
import org.bukkit.craftbukkit.v1_21_R5.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R5.util.CraftMagicNumbers;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

class ItemUtilsImpl
implements ItemUtils {
    ItemUtilsImpl() {
    }

    @Override
    public byte[] serializeItemStack(@NotNull ItemStack itemStack, boolean compressed) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serializeItemStack(itemStack, out, compressed);
        return out.toByteArray();
    }

    @Override
    public void serializeItemStack(@NotNull ItemStack itemStack, @NotNull OutputStream outputStream, boolean compressed) {
        try {
            net.minecraft.world.item.ItemStack nmsStack = CraftItemStack.asNMSCopy((ItemStack)itemStack);
            NBTTagCompound nbt = (NBTTagCompound)net.minecraft.world.item.ItemStack.b.encode((Object)nmsStack, (DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)DynamicOpsNBT.a), (Object)new NBTTagCompound()).getOrThrow();
            nbt.a("DataVersion", CraftMagicNumbers.INSTANCE.getDataVersion());
            if (compressed) {
                NBTCompressedStreamTools.a((NBTTagCompound)nbt, (OutputStream)outputStream);
            } else {
                DataOutputStream dataOut = new DataOutputStream(outputStream);
                NBTCompressedStreamTools.a((NBTTagCompound)nbt, (DataOutput)dataOut);
            }
            outputStream.flush();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public ItemStack deserializeItemStack(byte[] data, boolean compressed) {
        ByteArrayInputStream in = new ByteArrayInputStream(data);
        return this.deserializeItemStack(in, compressed);
    }

    @Override
    public ItemStack deserializeItemStack(@NotNull InputStream inputStream, boolean compressed) {
        try {
            NBTTagCompound nbt;
            if (compressed) {
                nbt = NBTCompressedStreamTools.a((InputStream)inputStream, (NBTReadLimiter)NBTReadLimiter.a());
            } else {
                DataInputStream dataIn = new DataInputStream(inputStream);
                nbt = NBTCompressedStreamTools.a((DataInput)dataIn);
            }
            int dataVersion = nbt.e("DataVersion").orElse(0);
            if (dataVersion == 0) {
                dataVersion = 3700;
            }
            Dynamic converted = DataConverterRegistry.a().update(DataConverterTypes.u, new Dynamic((DynamicOps)DynamicOpsNBT.a, (Object)nbt), dataVersion, CraftMagicNumbers.INSTANCE.getDataVersion());
            net.minecraft.world.item.ItemStack itemStack = net.minecraft.world.item.ItemStack.b.parse((DynamicOps)CraftRegistry.getMinecraftRegistry().a((DynamicOps)DynamicOpsNBT.a), (Object)((NBTBase)converted.getValue())).resultOrPartial().orElse(net.minecraft.world.item.ItemStack.l);
            return CraftItemStack.asCraftMirror((net.minecraft.world.item.ItemStack)itemStack);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public void setDisplayName(@NotNull ItemMeta itemMeta, @NotNull ComponentWrapper name) {
        ReflectionUtils.setFieldValue(ReflectionRegistry.CB_CRAFT_META_ITEM_DISPLAY_NAME_FIELD, itemMeta, InventoryUtilsImpl.createNMSComponent(name));
    }

    @Override
    public void setLore(@NotNull ItemMeta itemMeta, @NotNull @NotNull List<@NotNull ComponentWrapper> lore) {
        ReflectionUtils.setFieldValue(ReflectionRegistry.CB_CRAFT_META_ITEM_LORE_FIELD, itemMeta, lore.stream().map(InventoryUtilsImpl::createNMSComponent).collect(Collectors.toList()));
    }
}

