/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.inventoryaccess.util;

import java.util.Arrays;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.ComponentBuilder;
import net.md_5.bungee.api.chat.TextComponent;

public class BungeeComponentUtils {
    private static final BaseComponent FORMATTING_TEMPLATE = new ComponentBuilder("").italic(false).bold(false).strikethrough(false).underlined(false).obfuscated(false).color(ChatColor.WHITE).create()[0];

    public static BaseComponent[] withoutPreFormatting(String text) {
        return BungeeComponentUtils.withoutPreFormatting(TextComponent.fromLegacyText((String)text));
    }

    public static BaseComponent[] withoutPreFormatting(BaseComponent ... components) {
        BaseComponent[] duplicate = BungeeComponentUtils.duplicate(components);
        BaseComponent previousComponent = FORMATTING_TEMPLATE;
        for (BaseComponent component : duplicate) {
            component.copyFormatting(previousComponent, false);
            previousComponent = component;
        }
        return duplicate;
    }

    public static BaseComponent[] duplicate(BaseComponent ... components) {
        return (BaseComponent[])Arrays.stream(components).map(BaseComponent::duplicate).toArray(BaseComponent[]::new);
    }
}

