/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.inventoryaccess.util;

import com.thexfactor117.levels.bukkit.libs.inventoryaccess.util.ReflectionRegistry;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.version.InventoryAccessRevision;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReflectionUtils {
    @NotNull
    public static <T> Class<T> getImplClass(@NotNull String path) {
        try {
            return Class.forName("com.thexfactor117.levels.bukkit.libs.inventoryaccess." + InventoryAccessRevision.REQUIRED_REVISION.getPackageName() + "." + path);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @NotNull
    public static <T> Class<T> getCBClass(@NotNull String path) {
        return ReflectionUtils.getClass(ReflectionRegistry.CRAFT_BUKKIT_PACKAGE_PATH + "." + path);
    }

    @NotNull
    public static <T> Class<T> getClass(@NotNull String path) {
        try {
            return Class.forName(path);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Nullable
    public static <T> Class<T> getClassOrNull(@NotNull String path) {
        try {
            return Class.forName(path);
        }
        catch (Throwable t) {
            return null;
        }
    }

    @NotNull
    public static Field getField(@NotNull Class<?> clazz, boolean declared, @NotNull String name) {
        try {
            Field field;
            Field field2 = field = declared ? clazz.getDeclaredField(name) : clazz.getField(name);
            if (declared) {
                field.setAccessible(true);
            }
            return field;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @NotNull
    public static <T> Constructor<T> getConstructor(@NotNull Class<T> clazz, boolean declared, Class<?> ... parameterTypes) {
        try {
            Constructor<T> constructor;
            Constructor<T> constructor2 = constructor = declared ? clazz.getDeclaredConstructor(parameterTypes) : clazz.getConstructor(parameterTypes);
            if (declared) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Nullable
    public static <T> Constructor<T> getConstructorOrNull(@Nullable Class<T> clazz, boolean declared, Class<?> ... parameterTypes) {
        if (clazz == null) {
            return null;
        }
        try {
            Constructor<T> constructor;
            Constructor<T> constructor2 = constructor = declared ? clazz.getDeclaredConstructor(parameterTypes) : clazz.getConstructor(parameterTypes);
            if (declared) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (Throwable t) {
            return null;
        }
    }

    @NotNull
    public static <T> T constructEmpty(@NotNull Class<?> clazz) {
        try {
            return (T)ReflectionUtils.getConstructor(clazz, true, new Class[0]).newInstance(new Object[0]);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @NotNull
    public static <T> T construct(@NotNull Constructor<T> constructor, Object ... args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @NotNull
    public static Method getMethod(@NotNull Class<?> clazz, boolean declared, @NotNull String name, Class<?> ... parameterTypes) {
        try {
            Method method;
            Method method2 = method = declared ? clazz.getDeclaredMethod(name, parameterTypes) : clazz.getMethod(name, parameterTypes);
            if (declared) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Nullable
    public static Method getMethodOrNull(@Nullable Class<?> clazz, boolean declared, @NotNull String name, Class<?> ... parameterTypes) {
        if (clazz == null) {
            return null;
        }
        try {
            Method method;
            Method method2 = method = declared ? clazz.getDeclaredMethod(name, parameterTypes) : clazz.getMethod(name, parameterTypes);
            if (declared) {
                method.setAccessible(true);
            }
            return method;
        }
        catch (Throwable t) {
            return null;
        }
    }

    public static <T> T invokeMethod(@NotNull Method method, @Nullable Object obj, Object ... args) {
        try {
            return (T)method.invoke(obj, args);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    public static void setFieldValue(@NotNull Field field, @Nullable Object obj, @Nullable Object value) {
        try {
            field.set(obj, value);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }

    @Nullable
    public static <T> T getFieldValue(@NotNull Field field, @Nullable Object obj) {
        try {
            return (T)field.get(obj);
        }
        catch (Throwable t) {
            throw new RuntimeException(t);
        }
    }
}

