/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui;

import com.thexfactor117.levels.bukkit.libs.inventoryaccess.util.ReflectionRegistry;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.util.ReflectionUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InvUI
implements Listener {
    private static InvUI instance;
    private final List<Runnable> disableHandlers = new ArrayList<Runnable>();
    private Plugin plugin;

    private InvUI() {
    }

    @NotNull
    public static InvUI getInstance() {
        return instance == null ? (instance = new InvUI()) : instance;
    }

    @NotNull
    public Plugin getPlugin() {
        if (this.plugin == null) {
            this.setPlugin(this.tryFindPlugin());
            if (this.plugin == null) {
                throw new IllegalStateException("Plugin is not set. Set it using InvUI.getInstance().setPlugin(plugin);");
            }
        }
        return this.plugin;
    }

    @Nullable
    private Plugin tryFindPlugin() {
        ClassLoader loader = this.getClass().getClassLoader();
        try {
            if (ReflectionRegistry.PLUGIN_CLASS_LOADER_CLASS.isInstance(loader)) {
                return (Plugin)ReflectionUtils.getFieldValue(ReflectionRegistry.PLUGIN_CLASS_LOADER_PLUGIN_FIELD, loader);
            }
            if (ReflectionRegistry.PAPER_PLUGIN_CLASS_LOADER_CLASS != null && ReflectionRegistry.PAPER_PLUGIN_CLASS_LOADER_CLASS.isInstance(loader)) {
                return (Plugin)ReflectionUtils.invokeMethod(ReflectionRegistry.PAPER_PLUGIN_CLASS_LOADER_GET_LOADED_JAVA_PLUGIN_METHOD, loader, new Object[0]);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        return null;
    }

    public void setPlugin(@Nullable Plugin plugin) {
        if (this.plugin != null) {
            throw new IllegalStateException("Plugin is already set");
        }
        if (plugin == null) {
            return;
        }
        Bukkit.getPluginManager().registerEvents((Listener)this, plugin);
        this.plugin = plugin;
    }

    @NotNull
    public Logger getLogger() {
        return this.getPlugin().getLogger();
    }

    public void addDisableHandler(@NotNull Runnable runnable) {
        this.disableHandlers.add(runnable);
    }

    @EventHandler
    private void handlePluginDisable(PluginDisableEvent event) {
        if (event.getPlugin().equals((Object)this.plugin)) {
            this.disableHandlers.forEach(Runnable::run);
        }
    }
}

