/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.animation.impl;

import com.thexfactor117.levels.bukkit.libs.invui.InvUI;
import com.thexfactor117.levels.bukkit.libs.invui.animation.Animation;
import com.thexfactor117.levels.bukkit.libs.invui.gui.Gui;
import com.thexfactor117.levels.bukkit.libs.invui.util.SlotUtils;
import com.thexfactor117.levels.bukkit.libs.invui.window.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.scheduler.BukkitTask;
import org.jetbrains.annotations.NotNull;

public abstract class AbstractAnimation
implements Animation {
    private final List<Runnable> finishHandlers = new ArrayList<Runnable>();
    private final int tickDelay;
    private Gui gui;
    private int width;
    private int height;
    private List<Window> windows;
    private CopyOnWriteArrayList<Integer> slots;
    private BiConsumer<Integer, Integer> show;
    private BukkitTask task;
    private int frame;
    private int noViewerTicks;

    public AbstractAnimation(int tickDelay) {
        this.tickDelay = tickDelay;
    }

    @Override
    public void setGui(Gui gui) {
        this.gui = gui;
        this.width = gui.getWidth();
        this.height = gui.getHeight();
    }

    @Override
    public void setWindows(@NotNull List<Window> windows) {
        this.windows = windows;
    }

    @Override
    public void addShowHandler(@NotNull BiConsumer<Integer, Integer> show) {
        this.show = this.show != null ? this.show.andThen(show) : show;
    }

    @Override
    public void addFinishHandler(@NotNull Runnable finish) {
        this.finishHandlers.add(finish);
    }

    @Override
    public void start() {
        this.task = Bukkit.getScheduler().runTaskTimer(InvUI.getInstance().getPlugin(), () -> {
            if (this.getCurrentViewers().isEmpty()) {
                ++this.noViewerTicks;
                if (this.noViewerTicks > 3) {
                    this.gui.cancelAnimation();
                    return;
                }
            } else {
                this.noViewerTicks = 0;
            }
            this.handleFrame(this.frame);
            ++this.frame;
        }, 0L, (long)this.tickDelay);
    }

    @Override
    public void cancel() {
        this.task.cancel();
    }

    protected void finish() {
        this.task.cancel();
        this.finishHandlers.forEach(Runnable::run);
    }

    protected abstract void handleFrame(int var1);

    public CopyOnWriteArrayList<Integer> getSlots() {
        return this.slots;
    }

    @Override
    public void setSlots(List<Integer> slots) {
        this.slots = new CopyOnWriteArrayList<Integer>(slots);
    }

    protected void show(int ... slots) {
        for (int i : slots) {
            this.show.accept(this.frame, i);
        }
    }

    protected int convToIndex(int x, int y) {
        if (x >= this.width || y >= this.height) {
            throw new IllegalArgumentException("Coordinates out of bounds");
        }
        return SlotUtils.convertToIndex(x, y, this.width);
    }

    protected int getWidth() {
        return this.width;
    }

    protected int getHeight() {
        return this.height;
    }

    public Set<Player> getCurrentViewers() {
        return this.windows.stream().map(Window::getCurrentViewer).filter(Objects::nonNull).collect(Collectors.toSet());
    }
}

