/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.gui;

import com.thexfactor117.levels.bukkit.libs.invui.InvUI;
import com.thexfactor117.levels.bukkit.libs.invui.animation.Animation;
import com.thexfactor117.levels.bukkit.libs.invui.gui.Gui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.GuiParent;
import com.thexfactor117.levels.bukkit.libs.invui.gui.SlotElement;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Marker;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Structure;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.Inventory;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.ObscuredInventory;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.ReferencingInventory;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.event.ItemPreUpdateEvent;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.event.PlayerUpdateReason;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.event.UpdateReason;
import com.thexfactor117.levels.bukkit.libs.invui.item.Item;
import com.thexfactor117.levels.bukkit.libs.invui.item.ItemProvider;
import com.thexfactor117.levels.bukkit.libs.invui.item.ItemWrapper;
import com.thexfactor117.levels.bukkit.libs.invui.item.impl.controlitem.ControlItem;
import com.thexfactor117.levels.bukkit.libs.invui.util.ArrayUtils;
import com.thexfactor117.levels.bukkit.libs.invui.util.InventoryUtils;
import com.thexfactor117.levels.bukkit.libs.invui.util.ItemUtils;
import com.thexfactor117.levels.bukkit.libs.invui.util.SlotUtils;
import com.thexfactor117.levels.bukkit.libs.invui.window.AbstractDoubleWindow;
import com.thexfactor117.levels.bukkit.libs.invui.window.AbstractSingleWindow;
import com.thexfactor117.levels.bukkit.libs.invui.window.AbstractSplitWindow;
import com.thexfactor117.levels.bukkit.libs.invui.window.AbstractWindow;
import com.thexfactor117.levels.bukkit.libs.invui.window.Window;
import com.thexfactor117.levels.bukkit.libs.invui.window.WindowManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.bukkit.GameMode;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryAction;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractGui
implements Gui,
GuiParent {
    private final int width;
    private final int height;
    private final int size;
    private final SlotElement[] slotElements;
    private final Set<GuiParent> parents = new HashSet<GuiParent>();
    private boolean frozen;
    private boolean ignoreObscuredInventorySlots = true;
    private ItemProvider background;
    private Animation animation;
    private SlotElement[] animationElements;

    public AbstractGui(int width, int height) {
        this.width = width;
        this.height = height;
        this.size = width * height;
        this.slotElements = new SlotElement[this.size];
    }

    public void handleClick(int slotNumber, Player player, ClickType clickType, InventoryClickEvent event) {
        if (this.frozen || this.animation != null) {
            event.setCancelled(true);
            return;
        }
        SlotElement slotElement = this.slotElements[slotNumber];
        if (slotElement instanceof SlotElement.LinkedSlotElement) {
            SlotElement.LinkedSlotElement linkedElement = (SlotElement.LinkedSlotElement)slotElement;
            AbstractGui gui = (AbstractGui)linkedElement.getGui();
            gui.handleClick(linkedElement.getSlotIndex(), player, clickType, event);
        } else if (slotElement instanceof SlotElement.ItemSlotElement) {
            event.setCancelled(true);
            SlotElement.ItemSlotElement itemElement = (SlotElement.ItemSlotElement)slotElement;
            itemElement.getItem().handleClick(clickType, player, event);
        } else if (slotElement instanceof SlotElement.InventorySlotElement) {
            this.handleInvSlotElementClick((SlotElement.InventorySlotElement)slotElement, event);
        } else {
            event.setCancelled(true);
        }
    }

    protected void handleInvSlotElementClick(SlotElement.InventorySlotElement element, InventoryClickEvent event) {
        InventoryAction action = event.getAction();
        if (action != InventoryAction.DROP_ALL_CURSOR && action != InventoryAction.DROP_ONE_CURSOR) {
            event.setCancelled(true);
            Inventory inventory = element.getInventory();
            int slot = element.getSlot();
            Player player = (Player)event.getWhoClicked();
            ItemStack cursor = ItemUtils.takeUnlessEmpty(event.getCursor());
            ItemStack clicked = ItemUtils.takeUnlessEmpty(event.getCurrentItem());
            ItemStack technicallyClicked = inventory.getItem(slot);
            if (inventory.isSynced(slot, clicked) || this.didClickBackgroundItem(player, element, inventory, slot, clicked)) {
                switch (event.getClick().name()) {
                    case "LEFT": {
                        this.handleInvLeftClick(event, inventory, slot, player, technicallyClicked, cursor);
                        break;
                    }
                    case "RIGHT": {
                        this.handleInvRightClick(event, inventory, slot, player, technicallyClicked, cursor);
                        break;
                    }
                    case "SHIFT_RIGHT": 
                    case "SHIFT_LEFT": {
                        this.handleInvItemShift(event, inventory, slot, player, technicallyClicked);
                        break;
                    }
                    case "NUMBER_KEY": {
                        this.handleInvNumberKey(event, inventory, slot, player, technicallyClicked);
                        break;
                    }
                    case "SWAP_OFFHAND": {
                        this.handleInvOffHandKey(event, inventory, slot, player, technicallyClicked);
                        break;
                    }
                    case "DROP": {
                        this.handleInvDrop(false, event, inventory, slot, player, technicallyClicked);
                        break;
                    }
                    case "CONTROL_DROP": {
                        this.handleInvDrop(true, event, inventory, slot, player, technicallyClicked);
                        break;
                    }
                    case "DOUBLE_CLICK": {
                        this.handleInvDoubleClick(event, player, cursor);
                        break;
                    }
                    case "MIDDLE": {
                        this.handleInvMiddleClick(event, inventory, slot, player);
                        break;
                    }
                    default: {
                        InvUI.getInstance().getLogger().warning("Unknown click type: " + event.getClick().name());
                    }
                }
            }
        }
    }

    private boolean didClickBackgroundItem(Player player, SlotElement.InventorySlotElement element, Inventory inventory, int slot, ItemStack clicked) {
        String lang = player.getLocale();
        return !inventory.hasItem(slot) && (this.isBuilderSimilar(this.background, lang, clicked) || this.isBuilderSimilar(element.getBackground(), lang, clicked));
    }

    private boolean isBuilderSimilar(ItemProvider builder, String lang, ItemStack expected) {
        return builder != null && builder.get(lang).isSimilar(expected);
    }

    protected void handleInvLeftClick(InventoryClickEvent event, Inventory inventory, int slot, Player player, ItemStack clicked, ItemStack cursor) {
        if (clicked == null && cursor == null) {
            return;
        }
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        if (cursor == null) {
            if (inventory.setItem(updateReason, slot, null)) {
                event.setCursor(clicked);
            }
        } else if (clicked == null || cursor.isSimilar(clicked)) {
            int remains = inventory.putItem(updateReason, slot, cursor);
            if (remains == 0) {
                event.setCursor(null);
            } else {
                cursor.setAmount(remains);
                event.setCursor(cursor);
            }
        } else if (!cursor.isSimilar(clicked) && inventory.setItem(updateReason, slot, cursor)) {
            event.setCursor(clicked);
        }
    }

    protected void handleInvRightClick(InventoryClickEvent event, Inventory inventory, int slot, Player player, ItemStack clicked, ItemStack cursor) {
        if (clicked == null && cursor == null) {
            return;
        }
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        if (cursor == null) {
            int clickedAmount = clicked.getAmount();
            int newClickedAmount = clickedAmount / 2;
            int newCursorAmount = clickedAmount - newClickedAmount;
            cursor = clicked.clone();
            clicked.setAmount(newClickedAmount);
            cursor.setAmount(newCursorAmount);
            if (inventory.setItem(updateReason, slot, clicked)) {
                event.setCursor(cursor);
            }
        } else {
            ItemStack toAdd = cursor.clone();
            toAdd.setAmount(1);
            int remains = inventory.putItem(updateReason, slot, toAdd);
            if (remains == 0) {
                cursor.setAmount(cursor.getAmount() - 1);
                event.setCursor(cursor);
            }
        }
    }

    protected void handleInvItemShift(InventoryClickEvent event, Inventory inventory, int slot, Player player, ItemStack clicked) {
        if (clicked == null) {
            return;
        }
        ItemStack previousStack = clicked.clone();
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        Window window = WindowManager.getInstance().getOpenWindow(player);
        ItemPreUpdateEvent updateEvent = inventory.callPreUpdateEvent(updateReason, slot, previousStack, null);
        if (!updateEvent.isCancelled()) {
            int leftOverAmount;
            if (window instanceof AbstractDoubleWindow) {
                AbstractSplitWindow splitWindow;
                AbstractGui[] guis;
                AbstractGui otherGui = window instanceof AbstractSplitWindow ? ((guis = (splitWindow = (AbstractSplitWindow)window).getGuis())[0] == this ? guis[1] : guis[0]) : this;
                leftOverAmount = otherGui.putIntoFirstInventory(updateReason, clicked, inventory);
            } else {
                ReferencingInventory playerInventory = ReferencingInventory.fromReversedPlayerStorageContents(player.getInventory());
                leftOverAmount = playerInventory.addItem(null, inventory.getItem(slot));
            }
            clicked.setAmount(leftOverAmount);
            if (ItemUtils.isEmpty(clicked)) {
                clicked = null;
            }
            inventory.setItemSilently(slot, clicked);
            inventory.callPostUpdateEvent(updateReason, slot, previousStack, clicked);
        }
    }

    protected void handleInvNumberKey(InventoryClickEvent event, Inventory inventory, int slot, Player player, ItemStack clicked) {
        int hotbarButton;
        PlayerInventory playerInventory;
        ItemStack hotbarItem;
        PlayerUpdateReason updateReason;
        Window window = WindowManager.getInstance().getOpenWindow(player);
        if (window instanceof AbstractSingleWindow && inventory.setItem(updateReason = new PlayerUpdateReason(player, (InventoryEvent)event), slot, hotbarItem = ItemUtils.takeUnlessEmpty((playerInventory = player.getInventory()).getItem(hotbarButton = event.getHotbarButton())))) {
            playerInventory.setItem(hotbarButton, clicked);
        }
    }

    protected void handleInvOffHandKey(InventoryClickEvent event, Inventory inventory, int slot, Player player, ItemStack clicked) {
        PlayerInventory playerInventory;
        ItemStack offhandItem;
        PlayerUpdateReason updateReason;
        Window window = WindowManager.getInstance().getOpenWindow(player);
        if (window instanceof AbstractSingleWindow && inventory.setItem(updateReason = new PlayerUpdateReason(player, (InventoryEvent)event), slot, offhandItem = ItemUtils.takeUnlessEmpty((playerInventory = player.getInventory()).getItemInOffHand()))) {
            playerInventory.setItemInOffHand(clicked);
        }
    }

    protected void handleInvDrop(boolean ctrl, InventoryClickEvent event, Inventory inventory, int slot, Player player, ItemStack clicked) {
        if (clicked == null) {
            return;
        }
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        if (ctrl) {
            if (inventory.setItem(updateReason, slot, null)) {
                InventoryUtils.dropItemLikePlayer(player, clicked);
            }
        } else if (inventory.addItemAmount(updateReason, slot, -1) == -1) {
            clicked.setAmount(1);
            InventoryUtils.dropItemLikePlayer(player, clicked);
        }
    }

    protected void handleInvDoubleClick(InventoryClickEvent event, Player player, ItemStack cursor) {
        if (cursor == null) {
            return;
        }
        Window window = WindowManager.getInstance().getOpenWindow(player);
        ((AbstractWindow)window).handleCursorCollect(event);
    }

    protected void handleInvMiddleClick(InventoryClickEvent event, Inventory inventory, int slot, Player player) {
        if (player.getGameMode() != GameMode.CREATIVE) {
            return;
        }
        ItemStack cursor = inventory.getItem(slot);
        if (cursor != null) {
            cursor.setAmount(cursor.getMaxStackSize());
        }
        event.setCursor(cursor);
    }

    public boolean handleItemDrag(UpdateReason updateReason, int slot, ItemStack oldStack, ItemStack newStack) {
        int viSlot;
        SlotElement.InventorySlotElement invSlotElement;
        Inventory inventory;
        if (this.frozen || this.animation != null) {
            return false;
        }
        SlotElement element = this.getSlotElement(slot);
        if (element != null) {
            element = element.getHoldingElement();
        }
        if (element instanceof SlotElement.InventorySlotElement && (inventory = (invSlotElement = (SlotElement.InventorySlotElement)element).getInventory()).isSynced(viSlot = invSlotElement.getSlot(), oldStack)) {
            return inventory.setItem(updateReason, viSlot, newStack);
        }
        return false;
    }

    public void handleItemShift(InventoryClickEvent event) {
        ItemStack clicked;
        event.setCancelled(true);
        if (this.frozen || this.animation != null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        PlayerUpdateReason updateReason = new PlayerUpdateReason(player, (InventoryEvent)event);
        int amountLeft = this.putIntoFirstInventory(updateReason, clicked = event.getCurrentItem(), new Inventory[0]);
        if (amountLeft != clicked.getAmount()) {
            if (amountLeft != 0) {
                event.getCurrentItem().setAmount(amountLeft);
            } else {
                event.getClickedInventory().setItem(event.getSlot(), null);
            }
        }
    }

    protected int putIntoFirstInventory(UpdateReason updateReason, ItemStack itemStack, Inventory ... ignored) {
        Collection<Inventory> inventories = this.getAllInventories(ignored);
        int originalAmount = itemStack.getAmount();
        if (!inventories.isEmpty()) {
            for (Inventory inventory : inventories) {
                int amountLeft = inventory.addItem(updateReason, itemStack);
                if (originalAmount == amountLeft) continue;
                return amountLeft;
            }
        }
        return originalAmount;
    }

    public Map<Inventory, Set<Integer>> getAllInventorySlots(Inventory ... ignored) {
        HashMap<Inventory, Set> slots = new HashMap<Inventory, Set>();
        Set ignoredSet = Arrays.stream(ignored).collect(Collectors.toSet());
        for (SlotElement element : this.slotElements) {
            SlotElement.InventorySlotElement invElement;
            Inventory inventory;
            if (element == null || !((element = element.getHoldingElement()) instanceof SlotElement.InventorySlotElement) || ignoredSet.contains(inventory = (invElement = (SlotElement.InventorySlotElement)element).getInventory())) continue;
            slots.computeIfAbsent(inventory, i -> new HashSet()).add(invElement.getSlot());
        }
        return slots.entrySet().stream().sorted(Comparator.comparingInt(entry -> ((Inventory)entry.getKey()).getGuiPriority()).reversed()).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue, (a, b) -> a, LinkedHashMap::new));
    }

    public Collection<Inventory> getAllInventories(Inventory ... ignored) {
        if (!this.ignoreObscuredInventorySlots) {
            return this.getAllInventorySlots(ignored).keySet();
        }
        ArrayList<Inventory> inventories = new ArrayList<Inventory>();
        for (Map.Entry<Inventory, Set<Integer>> entry : this.getAllInventorySlots(ignored).entrySet()) {
            Inventory inventory = entry.getKey();
            Set<Integer> slots = entry.getValue();
            inventories.add(new ObscuredInventory(inventory, slot -> !slots.contains(slot)));
        }
        return inventories;
    }

    @Override
    public void handleSlotElementUpdate(Gui child, int slotIndex) {
        for (int index = 0; index < this.size; ++index) {
            SlotElement.LinkedSlotElement linkedSlotElement;
            SlotElement element = this.slotElements[index];
            if (!(element instanceof SlotElement.LinkedSlotElement) || (linkedSlotElement = (SlotElement.LinkedSlotElement)element).getGui() != child || linkedSlotElement.getSlotIndex() != slotIndex) continue;
            for (GuiParent parent : this.parents) {
                parent.handleSlotElementUpdate(this, index);
            }
        }
    }

    public void addParent(@NotNull GuiParent parent) {
        this.parents.add(parent);
    }

    public void removeParent(@NotNull GuiParent parent) {
        this.parents.remove(parent);
    }

    public Set<GuiParent> getParents() {
        return this.parents;
    }

    @Override
    @NotNull
    public @NotNull List<@NotNull Window> findAllWindows() {
        ArrayList<Window> windows = new ArrayList<Window>();
        ArrayList<GuiParent> unexploredParents = new ArrayList<GuiParent>(this.parents);
        while (!unexploredParents.isEmpty()) {
            ArrayList<GuiParent> parents = new ArrayList<GuiParent>(unexploredParents);
            unexploredParents.clear();
            for (GuiParent parent : parents) {
                if (parent instanceof AbstractGui) {
                    unexploredParents.addAll(((AbstractGui)parent).getParents());
                    continue;
                }
                if (!(parent instanceof Window)) continue;
                windows.add((Window)((Object)parent));
            }
        }
        return windows;
    }

    @Override
    @NotNull
    public @NotNull Set<@NotNull Player> findAllCurrentViewers() {
        return this.findAllWindows().stream().map(Window::getCurrentViewer).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    @Override
    public void closeForAllViewers() {
        this.findAllCurrentViewers().forEach(HumanEntity::closeInventory);
    }

    @Override
    public void playAnimation(@NotNull Animation animation, @Nullable Predicate<@NotNull SlotElement> filter) {
        if (animation != null) {
            this.cancelAnimation();
        }
        this.animation = animation;
        this.animationElements = (SlotElement[])this.slotElements.clone();
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int i = 0; i < this.size; ++i) {
            SlotElement element = this.getSlotElement(i);
            if (element == null || filter != null && !filter.test(element)) continue;
            slots.add(i);
            this.setSlotElement(i, null);
        }
        animation.setSlots(slots);
        animation.setGui(this);
        animation.setWindows(this.findAllWindows());
        animation.addShowHandler((frame, index) -> this.setSlotElement((int)index, this.animationElements[index]));
        animation.addFinishHandler(() -> {
            this.animation = null;
            this.animationElements = null;
        });
        animation.start();
    }

    @Override
    public void cancelAnimation() {
        if (this.animation != null) {
            this.animation.cancel();
            this.animation = null;
            for (int i = 0; i < this.size; ++i) {
                this.setSlotElement(i, this.animationElements[i]);
            }
            this.animationElements = null;
        }
    }

    public void updateControlItems() {
        for (SlotElement element : this.slotElements) {
            Item item;
            if (!(element instanceof SlotElement.ItemSlotElement) || !((item = ((SlotElement.ItemSlotElement)element).getItem()) instanceof ControlItem)) continue;
            item.notifyWindows();
        }
    }

    @Override
    public void setSlotElement(int index, SlotElement slotElement) {
        AbstractGui newLink;
        Item item;
        SlotElement oldElement = this.slotElements[index];
        this.slotElements[index] = slotElement;
        if (slotElement instanceof SlotElement.ItemSlotElement && (item = ((SlotElement.ItemSlotElement)slotElement).getItem()) instanceof ControlItem) {
            ((ControlItem)item).setGui(this);
        }
        this.parents.forEach(parent -> parent.handleSlotElementUpdate(this, index));
        AbstractGui oldLink = oldElement instanceof SlotElement.LinkedSlotElement ? (AbstractGui)((SlotElement.LinkedSlotElement)oldElement).getGui() : null;
        AbstractGui abstractGui = newLink = slotElement instanceof SlotElement.LinkedSlotElement ? (AbstractGui)((SlotElement.LinkedSlotElement)slotElement).getGui() : null;
        if (newLink == oldLink) {
            return;
        }
        if (oldLink != null && Arrays.stream(this.slotElements).filter(element -> element instanceof SlotElement.LinkedSlotElement).map(element -> ((SlotElement.LinkedSlotElement)element).getGui()).noneMatch(gui -> gui == oldLink)) {
            oldLink.removeParent(this);
        }
        if (newLink != null) {
            newLink.addParent(this);
        }
    }

    @Override
    public void addSlotElements(SlotElement ... slotElements) {
        for (SlotElement element : slotElements) {
            int emptyIndex = ArrayUtils.findFirstEmptyIndex(this.slotElements);
            if (emptyIndex == -1) break;
            this.setSlotElement(emptyIndex, element);
        }
    }

    @Override
    @Nullable
    public SlotElement getSlotElement(int index) {
        return this.slotElements[index];
    }

    @Override
    public boolean hasSlotElement(int index) {
        return this.slotElements[index] != null;
    }

    @Override
    public @Nullable SlotElement @NotNull [] getSlotElements() {
        return (SlotElement[])this.slotElements.clone();
    }

    @Override
    public void setItem(int index, @Nullable Item item) {
        this.remove(index);
        if (item != null) {
            this.setSlotElement(index, new SlotElement.ItemSlotElement(item));
        }
    }

    @Override
    public void addItems(Item ... items) {
        for (Item item : items) {
            int emptyIndex = ArrayUtils.findFirstEmptyIndex(this.slotElements);
            if (emptyIndex == -1) break;
            this.setItem(emptyIndex, item);
        }
    }

    @Override
    @Nullable
    public Item getItem(int index) {
        SlotElement holdingElement;
        SlotElement slotElement = this.slotElements[index];
        if (slotElement instanceof SlotElement.ItemSlotElement) {
            return ((SlotElement.ItemSlotElement)slotElement).getItem();
        }
        if (slotElement instanceof SlotElement.LinkedSlotElement && (holdingElement = slotElement.getHoldingElement()) instanceof SlotElement.ItemSlotElement) {
            return ((SlotElement.ItemSlotElement)holdingElement).getItem();
        }
        return null;
    }

    @Override
    @Nullable
    public ItemProvider getBackground() {
        return this.background;
    }

    @Override
    public void setBackground(ItemProvider itemProvider) {
        this.background = itemProvider;
    }

    @Override
    public void remove(int index) {
        this.setSlotElement(index, null);
    }

    @Override
    public void applyStructure(@NotNull Structure structure) {
        structure.getIngredientList().insertIntoGui(this);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public void setFrozen(boolean frozen) {
        this.frozen = frozen;
    }

    @Override
    public boolean isFrozen() {
        return this.frozen;
    }

    @Override
    public void setIgnoreObscuredInventorySlots(boolean ignoreObscuredInventorySlots) {
        this.ignoreObscuredInventorySlots = ignoreObscuredInventorySlots;
    }

    @Override
    public boolean isIgnoreObscuredInventorySlots() {
        return this.ignoreObscuredInventorySlots;
    }

    @Override
    public void setSlotElement(int x, int y, SlotElement slotElement) {
        this.setSlotElement(this.convToIndex(x, y), slotElement);
    }

    @Override
    @Nullable
    public SlotElement getSlotElement(int x, int y) {
        return this.getSlotElement(this.convToIndex(x, y));
    }

    @Override
    public boolean hasSlotElement(int x, int y) {
        return this.hasSlotElement(this.convToIndex(x, y));
    }

    @Override
    public void setItem(int x, int y, @Nullable Item item) {
        this.setItem(this.convToIndex(x, y), item);
    }

    @Override
    @Nullable
    public Item getItem(int x, int y) {
        return this.getItem(this.convToIndex(x, y));
    }

    @Override
    public void remove(int x, int y) {
        this.remove(this.convToIndex(x, y));
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    private int convToIndex(int x, int y) {
        if (x >= this.width || y >= this.height) {
            throw new IllegalArgumentException("Coordinates out of bounds");
        }
        return SlotUtils.convertToIndex(x, y, this.width);
    }

    private void fill(@NotNull Set<Integer> slots, @Nullable Item item, boolean replaceExisting) {
        for (int slot : slots) {
            if (!replaceExisting && this.hasSlotElement(slot)) continue;
            this.setItem(slot, item);
        }
    }

    @Override
    public void fill(int start, int end, @Nullable Item item, boolean replaceExisting) {
        for (int i = start; i < end; ++i) {
            if (!replaceExisting && this.hasSlotElement(i)) continue;
            this.setItem(i, item);
        }
    }

    @Override
    public void fill(@Nullable Item item, boolean replaceExisting) {
        this.fill(0, this.getSize(), item, replaceExisting);
    }

    @Override
    public void fillRow(int row, @Nullable Item item, boolean replaceExisting) {
        if (row >= this.height) {
            throw new IllegalArgumentException("Row out of bounds");
        }
        this.fill(SlotUtils.getSlotsRow(row, this.width), item, replaceExisting);
    }

    @Override
    public void fillColumn(int column, @Nullable Item item, boolean replaceExisting) {
        if (column >= this.width) {
            throw new IllegalArgumentException("Column out of bounds");
        }
        this.fill(SlotUtils.getSlotsColumn(column, this.width, this.height), item, replaceExisting);
    }

    @Override
    public void fillBorders(@Nullable Item item, boolean replaceExisting) {
        this.fill(SlotUtils.getSlotsBorders(this.width, this.height), item, replaceExisting);
    }

    @Override
    public void fillRectangle(int x, int y, int width, int height, @Nullable Item item, boolean replaceExisting) {
        this.fill(SlotUtils.getSlotsRect(x, y, width, height, this.width), item, replaceExisting);
    }

    @Override
    public void fillRectangle(int x, int y, @NotNull Gui gui, boolean replaceExisting) {
        int slotIndex = 0;
        for (int slot : SlotUtils.getSlotsRect(x, y, gui.getWidth(), gui.getHeight(), this.width)) {
            if (this.hasSlotElement(slot) && !replaceExisting) continue;
            this.setSlotElement(slot, new SlotElement.LinkedSlotElement(gui, slotIndex));
            ++slotIndex;
        }
    }

    @Override
    public void fillRectangle(int x, int y, int width, @NotNull Inventory inventory, boolean replaceExisting) {
        this.fillRectangle(x, y, width, inventory, null, replaceExisting);
    }

    @Override
    public void fillRectangle(int x, int y, int width, @NotNull Inventory inventory, @Nullable ItemProvider background, boolean replaceExisting) {
        int height = (int)Math.ceil((double)inventory.getSize() / (double)width);
        int slotIndex = 0;
        for (int slot : SlotUtils.getSlotsRect(x, y, width, height, this.width)) {
            if (slotIndex >= inventory.getSize()) {
                return;
            }
            if (this.hasSlotElement(slot) && !replaceExisting) continue;
            this.setSlotElement(slot, new SlotElement.InventorySlotElement(inventory, slotIndex, background));
            ++slotIndex;
        }
    }

    public static abstract class AbstractBuilder<G extends Gui, S extends Gui.Builder<G, S>>
    implements Gui.Builder<G, S> {
        protected Structure structure;
        protected ItemProvider background;
        protected List<Consumer<G>> modifiers;
        protected boolean frozen;
        protected boolean ignoreObscuredInventorySlots = true;

        @Override
        @NotNull
        public S setStructure(int width, int height, @NotNull String structureData) {
            this.structure = new Structure(width, height, structureData);
            return (S)this;
        }

        @Override
        @NotNull
        public S setStructure(String ... structureData) {
            this.structure = new Structure(structureData);
            return (S)this;
        }

        @Override
        @NotNull
        public S setStructure(@NotNull Structure structure) {
            this.structure = structure;
            return (S)this;
        }

        @Override
        @NotNull
        public S addIngredient(char key, @NotNull ItemStack itemStack) {
            this.structure.addIngredient(key, itemStack);
            return (S)this;
        }

        @Override
        @NotNull
        public S addIngredient(char key, @NotNull ItemProvider itemProvider) {
            this.structure.addIngredient(key, itemProvider);
            return (S)this;
        }

        @Override
        @NotNull
        public S addIngredient(char key, @NotNull Item item) {
            this.structure.addIngredient(key, item);
            return (S)this;
        }

        @Override
        @NotNull
        public S addIngredient(char key, @NotNull Inventory inventory) {
            this.structure.addIngredient(key, inventory);
            return (S)this;
        }

        @Override
        @NotNull
        public S addIngredient(char key, @NotNull Inventory inventory, @Nullable ItemProvider background) {
            this.structure.addIngredient(key, inventory, background);
            return (S)this;
        }

        @Override
        @NotNull
        public S addIngredient(char key, @NotNull SlotElement element) {
            this.structure.addIngredient(key, element);
            return (S)this;
        }

        @Override
        @NotNull
        public S addIngredient(char key, @NotNull Marker marker) {
            this.structure.addIngredient(key, marker);
            return (S)this;
        }

        @Override
        @NotNull
        public S addIngredient(char key, @NotNull Supplier<? extends Item> itemSupplier) {
            this.structure.addIngredient(key, itemSupplier);
            return (S)this;
        }

        @Override
        @NotNull
        public S addIngredientElementSupplier(char key, @NotNull Supplier<? extends SlotElement> elementSupplier) {
            this.structure.addIngredientElementSupplier(key, elementSupplier);
            return (S)this;
        }

        @Override
        @NotNull
        public S setBackground(@NotNull ItemProvider itemProvider) {
            this.background = itemProvider;
            return (S)this;
        }

        @Override
        @NotNull
        public S setBackground(@NotNull ItemStack itemStack) {
            this.background = new ItemWrapper(itemStack);
            return (S)this;
        }

        @Override
        @NotNull
        public S setFrozen(boolean frozen) {
            this.frozen = frozen;
            return (S)this;
        }

        @Override
        @NotNull
        public S setIgnoreObscuredInventorySlots(boolean ignoreObscuredInventorySlots) {
            this.ignoreObscuredInventorySlots = ignoreObscuredInventorySlots;
            return (S)this;
        }

        @Override
        @NotNull
        public S addModifier(@NotNull @NotNull Consumer<@NotNull G> modifier) {
            if (this.modifiers == null) {
                this.modifiers = new ArrayList<Consumer<G>>();
            }
            this.modifiers.add(modifier);
            return (S)this;
        }

        @Override
        @NotNull
        public S setModifiers(@NotNull @NotNull List<@NotNull Consumer<@NotNull G>> modifiers) {
            this.modifiers = modifiers;
            return (S)this;
        }

        protected void applyModifiers(@NotNull G gui) {
            gui.setFrozen(this.frozen);
            gui.setIgnoreObscuredInventorySlots(this.ignoreObscuredInventorySlots);
            if (this.background != null) {
                gui.setBackground(this.background);
            }
            if (this.modifiers != null) {
                this.modifiers.forEach(modifier -> modifier.accept(gui));
            }
        }

        @Override
        @NotNull
        public S clone() {
            try {
                AbstractBuilder clone = (AbstractBuilder)super.clone();
                clone.structure = this.structure.clone();
                if (this.modifiers != null) {
                    clone.modifiers = new ArrayList<Consumer<G>>(this.modifiers);
                }
                return (S)clone;
            }
            catch (CloneNotSupportedException e) {
                throw new AssertionError();
            }
        }
    }
}

