/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.gui;

import com.thexfactor117.levels.bukkit.libs.invui.gui.AbstractGui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.PagedGui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.SlotElement;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Structure;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractPagedGui<C>
extends AbstractGui
implements PagedGui<C> {
    private final boolean infinitePages;
    private final int[] contentListSlots;
    private int currentPage;
    private List<BiConsumer<Integer, Integer>> pageChangeHandlers;
    protected List<C> content;
    protected List<List<SlotElement>> pages;

    public AbstractPagedGui(int width, int height, boolean infinitePages, int ... contentListSlots) {
        super(width, height);
        this.infinitePages = infinitePages;
        this.contentListSlots = contentListSlots;
    }

    public AbstractPagedGui(int width, int height, boolean infinitePages, Structure structure) {
        this(width, height, infinitePages, structure.getIngredientList().findContentListSlots());
        this.applyStructure(structure);
    }

    @Override
    public void goForward() {
        if (this.hasNextPage()) {
            this.setPage(this.currentPage + 1);
        }
    }

    @Override
    public void goBack() {
        if (this.hasPreviousPage()) {
            this.setPage(this.currentPage - 1);
        }
    }

    @Override
    public void setPage(int page) {
        int previousPage = this.currentPage;
        int newPage = this.correctPage(page);
        if (previousPage == newPage) {
            return;
        }
        this.currentPage = newPage;
        this.update();
        if (this.pageChangeHandlers != null) {
            this.pageChangeHandlers.forEach(handler -> handler.accept(previousPage, newPage));
        }
    }

    private int correctPage(int page) {
        if (page == 0 || this.infinitePages && page > 0) {
            return page;
        }
        return Math.max(0, Math.min(page, this.getPageAmount() - 1));
    }

    private void correctCurrentPage() {
        int correctedPage = this.correctPage(this.currentPage);
        if (correctedPage != this.currentPage) {
            this.setPage(correctedPage);
        }
    }

    @Override
    public boolean hasNextPage() {
        return this.currentPage < this.getPageAmount() - 1 || this.infinitePages;
    }

    @Override
    public boolean hasPreviousPage() {
        return this.currentPage > 0;
    }

    protected void update() {
        this.correctCurrentPage();
        this.updateControlItems();
        this.updatePageContent();
    }

    private void updatePageContent() {
        List slotElements = this.pages != null && !this.pages.isEmpty() ? this.pages.get(this.currentPage) : List.of();
        for (int i = 0; i < this.contentListSlots.length; ++i) {
            if (slotElements.size() > i) {
                this.setSlotElement(this.contentListSlots[i], (SlotElement)slotElements.get(i));
                continue;
            }
            this.remove(this.contentListSlots[i]);
        }
    }

    @Override
    public void setContent(@Nullable List<C> content) {
        if (content == null || content.isEmpty()) {
            this.content = List.of();
            this.pages = List.of();
            this.update();
        } else {
            this.content = content;
            this.bake();
        }
    }

    @Override
    public int getPageAmount() {
        return this.pages != null ? this.pages.size() : 0;
    }

    @Override
    public int getCurrentPage() {
        return this.currentPage;
    }

    @Override
    public boolean hasInfinitePages() {
        return this.infinitePages;
    }

    @Override
    public int[] getContentListSlots() {
        return this.contentListSlots;
    }

    @Override
    public void addPageChangeHandler(@NotNull BiConsumer<Integer, Integer> pageChangeHandler) {
        if (this.pageChangeHandlers == null) {
            this.pageChangeHandlers = new ArrayList<BiConsumer<Integer, Integer>>();
        }
        this.pageChangeHandlers.add(pageChangeHandler);
    }

    @Override
    public void removePageChangeHandler(@NotNull BiConsumer<Integer, Integer> pageChangeHandler) {
        if (this.pageChangeHandlers != null) {
            this.pageChangeHandlers.remove(pageChangeHandler);
        }
    }

    @Override
    public void setPageChangeHandlers(@Nullable List<@NotNull BiConsumer<Integer, Integer>> handlers) {
        this.pageChangeHandlers = handlers;
    }

    @Override
    @Nullable
    public List<BiConsumer<Integer, Integer>> getPageChangeHandlers() {
        return this.pageChangeHandlers;
    }

    public static abstract class AbstractBuilder<C>
    extends AbstractGui.AbstractBuilder<PagedGui<C>, PagedGui.Builder<C>>
    implements PagedGui.Builder<C> {
        protected List<C> content;
        protected List<BiConsumer<Integer, Integer>> pageChangeHandlers;

        @Override
        public @NotNull PagedGui.Builder<C> setContent(@NotNull @NotNull List<@NotNull C> content) {
            this.content = content;
            return this;
        }

        @Override
        public @NotNull PagedGui.Builder<C> addContent(@NotNull C content) {
            if (this.content == null) {
                this.content = new ArrayList<C>();
            }
            this.content.add(content);
            return this;
        }

        @Override
        public @NotNull PagedGui.Builder<C> setPageChangeHandlers(@NotNull @NotNull List<@NotNull BiConsumer<Integer, Integer>> handlers) {
            this.pageChangeHandlers = handlers;
            return this;
        }

        @Override
        public @NotNull PagedGui.Builder<C> addPageChangeHandler(@NotNull BiConsumer<Integer, Integer> handler) {
            if (this.pageChangeHandlers == null) {
                this.pageChangeHandlers = new ArrayList<BiConsumer<Integer, Integer>>(1);
            }
            this.pageChangeHandlers.add(handler);
            return this;
        }

        @Override
        protected void applyModifiers(@NotNull PagedGui<C> gui) {
            super.applyModifiers(gui);
            gui.setPageChangeHandlers(this.pageChangeHandlers);
        }

        @Override
        @NotNull
        public PagedGui.Builder<C> clone() {
            AbstractBuilder clone = (AbstractBuilder)super.clone();
            if (this.content != null) {
                clone.content = new ArrayList<C>(this.content);
            }
            if (this.pageChangeHandlers != null) {
                clone.pageChangeHandlers = new ArrayList<BiConsumer<Integer, Integer>>(this.pageChangeHandlers);
            }
            return clone;
        }
    }
}

