/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.gui;

import com.thexfactor117.levels.bukkit.libs.invui.gui.AbstractGui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.ScrollGui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.SlotElement;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Structure;
import com.thexfactor117.levels.bukkit.libs.invui.util.SlotUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractScrollGui<C>
extends AbstractGui
implements ScrollGui<C> {
    private final boolean infiniteLines;
    private final int lineLength;
    private final int lineAmount;
    private final int[] contentListSlots;
    private int currentLine;
    private int offset;
    private List<BiConsumer<Integer, Integer>> scrollHandlers;
    protected List<C> content;
    protected List<SlotElement> elements;

    public AbstractScrollGui(int width, int height, boolean infiniteLines, int ... contentListSlots) {
        super(width, height);
        this.infiniteLines = infiniteLines;
        this.contentListSlots = contentListSlots;
        this.lineLength = SlotUtils.getLongestLineLength(contentListSlots, width);
        this.lineAmount = (int)Math.ceil((double)contentListSlots.length / (double)this.lineLength);
        if (contentListSlots.length == 0) {
            throw new IllegalArgumentException("No item list slots provided");
        }
        if (this.lineLength == 0) {
            throw new IllegalArgumentException("Line length can't be 0");
        }
        if (contentListSlots.length % this.lineLength != 0) {
            throw new IllegalArgumentException("contentListSlots has to be a multiple of lineLength");
        }
    }

    public AbstractScrollGui(int width, int height, boolean infiniteLines, Structure structure) {
        this(width, height, infiniteLines, structure.getIngredientList().findContentListSlots());
        this.applyStructure(structure);
    }

    public int getLineLength() {
        return this.lineLength;
    }

    @Override
    public int getCurrentLine() {
        return this.currentLine;
    }

    @Override
    public void setCurrentLine(int line) {
        int previousLine = this.currentLine;
        int newLine = this.correctLine(line);
        if (previousLine == newLine) {
            return;
        }
        this.currentLine = line;
        this.offset = line * this.lineLength;
        this.update();
        if (this.scrollHandlers != null) {
            this.scrollHandlers.forEach(handler -> handler.accept(previousLine, newLine));
        }
    }

    private int correctLine(int line) {
        if (line == 0 || this.infiniteLines && line > 0) {
            return 0;
        }
        return Math.max(0, Math.min(line, this.getMaxLine()));
    }

    private void correctCurrentLine() {
        int correctedLine = this.correctLine(this.currentLine);
        if (correctedLine != this.currentLine) {
            this.setCurrentLine(correctedLine);
        }
    }

    @Override
    public boolean canScroll(int lines) {
        if (lines == 0 || this.infiniteLines && lines > 0 || lines < 0 && this.getCurrentLine() > 0) {
            return true;
        }
        int line = this.getCurrentLine() + lines;
        int maxLineIndex = this.getMaxLine();
        return line >= 0 && line + this.lineAmount - 1 <= maxLineIndex;
    }

    @Override
    public void scroll(int lines) {
        if (lines == 0) {
            return;
        }
        if (this.canScroll(lines)) {
            this.setCurrentLine(this.getCurrentLine() + lines);
        } else if (lines > 1) {
            this.setCurrentLine(this.getMaxLine());
        } else if (lines < -1) {
            this.setCurrentLine(0);
        }
    }

    @Override
    public int getMaxLine() {
        if (this.elements == null) {
            return 0;
        }
        return (int)Math.ceil((double)this.elements.size() / (double)this.getLineLength()) - 1;
    }

    @Override
    public void setContent(@Nullable List<C> content) {
        if (content == null || content.isEmpty()) {
            this.content = List.of();
            this.elements = List.of();
            this.update();
        } else {
            this.content = content;
            this.bake();
        }
    }

    protected void update() {
        this.correctCurrentLine();
        this.updateControlItems();
        this.updateContent();
    }

    private void updateContent() {
        List<SlotElement> slotElements = this.elements.subList(this.offset, Math.min(this.elements.size(), this.contentListSlots.length + this.offset));
        for (int i = 0; i < this.contentListSlots.length; ++i) {
            if (slotElements.size() > i) {
                this.setSlotElement(this.contentListSlots[i], slotElements.get(i));
                continue;
            }
            this.remove(this.contentListSlots[i]);
        }
    }

    @Override
    public void setScrollHandlers(@NotNull @NotNull List<@NotNull BiConsumer<Integer, Integer>> scrollHandlers) {
        this.scrollHandlers = scrollHandlers;
    }

    @Override
    public void addScrollHandler(@NotNull BiConsumer<Integer, Integer> scrollHandler) {
        if (this.scrollHandlers == null) {
            this.scrollHandlers = new ArrayList<BiConsumer<Integer, Integer>>();
        }
        this.scrollHandlers.add(scrollHandler);
    }

    @Override
    public void removeScrollHandler(@NotNull BiConsumer<Integer, Integer> scrollHandler) {
        if (this.scrollHandlers != null) {
            this.scrollHandlers.remove(scrollHandler);
        }
    }

    public static abstract class AbstractBuilder<C>
    extends AbstractGui.AbstractBuilder<ScrollGui<C>, ScrollGui.Builder<C>>
    implements ScrollGui.Builder<C> {
        protected List<C> content;
        protected List<BiConsumer<Integer, Integer>> scrollHandlers;

        @Override
        public @NotNull ScrollGui.Builder<C> setContent(@NotNull @NotNull List<@NotNull C> content) {
            this.content = content;
            return this;
        }

        @Override
        public @NotNull ScrollGui.Builder<C> addContent(@NotNull C content) {
            if (this.content == null) {
                this.content = new ArrayList<C>();
            }
            this.content.add(content);
            return this;
        }

        @Override
        public @NotNull ScrollGui.Builder<C> setScrollHandlers(@NotNull @NotNull List<@NotNull BiConsumer<Integer, Integer>> handlers) {
            this.scrollHandlers = handlers;
            return this;
        }

        @Override
        public @NotNull ScrollGui.Builder<C> addScrollHandler(@NotNull BiConsumer<Integer, Integer> handler) {
            if (this.scrollHandlers == null) {
                this.scrollHandlers = new ArrayList<BiConsumer<Integer, Integer>>(1);
            }
            this.scrollHandlers.add(handler);
            return this;
        }

        @Override
        protected void applyModifiers(@NotNull ScrollGui<C> gui) {
            super.applyModifiers(gui);
            gui.setScrollHandlers(this.scrollHandlers);
        }

        @Override
        @NotNull
        public ScrollGui.Builder<C> clone() {
            AbstractBuilder clone = (AbstractBuilder)super.clone();
            if (this.content != null) {
                clone.content = new ArrayList<C>(this.content);
            }
            if (this.scrollHandlers != null) {
                clone.scrollHandlers = new ArrayList<BiConsumer<Integer, Integer>>(this.scrollHandlers);
            }
            return clone;
        }
    }
}

