/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.gui;

import com.thexfactor117.levels.bukkit.libs.invui.gui.AbstractGui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.Gui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.SlotElement;
import com.thexfactor117.levels.bukkit.libs.invui.gui.TabGui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Structure;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractTabGui
extends AbstractGui
implements TabGui {
    private final int tabAmount;
    private final int[] listSlots;
    private int currentTab = -1;
    private List<BiConsumer<Integer, Integer>> tabChangeHandlers;

    public AbstractTabGui(int width, int height, int tabAmount, int ... listSlots) {
        super(width, height);
        this.tabAmount = tabAmount;
        this.listSlots = listSlots;
    }

    public AbstractTabGui(int width, int height, int tabAmount, Structure structure) {
        this(width, height, tabAmount, structure.getIngredientList().findContentListSlots());
        this.applyStructure(structure);
    }

    @Override
    public void setTab(int tab) {
        if (tab < 0 || tab >= this.tabAmount) {
            throw new IllegalArgumentException("Tab out of bounds");
        }
        if (!this.isTabAvailable(tab)) {
            return;
        }
        int previous = this.currentTab;
        this.currentTab = tab;
        this.update();
        if (this.tabChangeHandlers != null) {
            this.tabChangeHandlers.forEach(handler -> handler.accept(previous, tab));
        }
    }

    protected void update() {
        if (this.currentTab == -1) {
            this.currentTab = this.getFirstAvailableTab();
        }
        this.updateControlItems();
        this.updateContent();
    }

    private void updateContent() {
        List<SlotElement> slotElements = this.getSlotElements(this.currentTab);
        for (int i = 0; i < this.listSlots.length; ++i) {
            int slot = this.listSlots[i];
            if (slotElements.size() > i) {
                this.setSlotElement(this.listSlots[i], slotElements.get(i));
                continue;
            }
            this.remove(slot);
        }
    }

    public int getFirstAvailableTab() {
        for (int tab = 0; tab < this.tabAmount; ++tab) {
            if (!this.isTabAvailable(tab)) continue;
            return tab;
        }
        throw new UnsupportedOperationException("At least one tab needs to be available");
    }

    @Override
    public int getCurrentTab() {
        return this.currentTab;
    }

    @Override
    public @Nullable List<@NotNull BiConsumer<Integer, Integer>> getTabChangeHandlers() {
        return this.tabChangeHandlers;
    }

    @Override
    public void setTabChangeHandlers(@Nullable List<@NotNull BiConsumer<Integer, Integer>> tabChangeHandlers) {
        this.tabChangeHandlers = tabChangeHandlers;
    }

    @Override
    public void addTabChangeHandler(@NotNull BiConsumer<Integer, Integer> tabChangeHandler) {
        if (this.tabChangeHandlers == null) {
            this.tabChangeHandlers = new ArrayList<BiConsumer<Integer, Integer>>();
        }
        this.tabChangeHandlers.add(tabChangeHandler);
    }

    @Override
    public void removeTabChangeHandler(@NotNull BiConsumer<Integer, Integer> tabChangeHandler) {
        if (this.tabChangeHandlers != null) {
            this.tabChangeHandlers.remove(tabChangeHandler);
        }
    }

    @Override
    public abstract boolean isTabAvailable(int var1);

    protected abstract List<SlotElement> getSlotElements(int var1);

    public static abstract class AbstractBuilder
    extends AbstractGui.AbstractBuilder<TabGui, TabGui.Builder>
    implements TabGui.Builder {
        protected List<Gui> tabs;
        protected List<BiConsumer<Integer, Integer>> tabChangeHandlers;

        @Override
        public @NotNull TabGui.Builder setTabs(@NotNull List<@Nullable Gui> tabs) {
            this.tabs = tabs;
            return this;
        }

        @Override
        public @NotNull TabGui.Builder addTab(@Nullable Gui tab) {
            if (this.tabs == null) {
                this.tabs = new ArrayList<Gui>();
            }
            this.tabs.add(tab);
            return this;
        }

        @Override
        public @NotNull TabGui.Builder addTabChangeHandler(@NotNull BiConsumer<Integer, Integer> handler) {
            if (this.tabChangeHandlers == null) {
                this.tabChangeHandlers = new ArrayList<BiConsumer<Integer, Integer>>(1);
            }
            this.tabChangeHandlers.add(handler);
            return this;
        }

        @Override
        public @NotNull TabGui.Builder setTabChangeHandlers(@NotNull @NotNull List<@NotNull BiConsumer<Integer, Integer>> handlers) {
            this.tabChangeHandlers = handlers;
            return this;
        }

        @Override
        protected void applyModifiers(@NotNull TabGui gui) {
            super.applyModifiers(gui);
            gui.setTabChangeHandlers(this.tabChangeHandlers);
        }

        @Override
        @NotNull
        public TabGui.Builder clone() {
            AbstractBuilder clone = (AbstractBuilder)super.clone();
            if (this.tabs != null) {
                clone.tabs = new ArrayList<Gui>(this.tabs);
            }
            if (this.tabChangeHandlers != null) {
                clone.tabChangeHandlers = new ArrayList<BiConsumer<Integer, Integer>>(this.tabChangeHandlers);
            }
            return clone;
        }
    }
}

