/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.gui;

import com.thexfactor117.levels.bukkit.libs.invui.gui.Gui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.PagedInventoriesGuiImpl;
import com.thexfactor117.levels.bukkit.libs.invui.gui.PagedItemsGuiImpl;
import com.thexfactor117.levels.bukkit.libs.invui.gui.PagedNestedGuiImpl;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Structure;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.Inventory;
import com.thexfactor117.levels.bukkit.libs.invui.item.Item;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface PagedGui<C>
extends Gui {
    @NotNull
    public static @NotNull Builder<@NotNull Item> items() {
        return new PagedItemsGuiImpl.Builder();
    }

    @NotNull
    public static @NotNull PagedGui<@NotNull Item> items(@NotNull @NotNull Consumer<@NotNull Builder<@NotNull Item>> consumer) {
        Builder<Item> builder = PagedGui.items();
        consumer.accept(builder);
        return (PagedGui)builder.build();
    }

    @NotNull
    public static @NotNull PagedGui<@NotNull Item> ofItems(int width, int height, @NotNull @NotNull List<@NotNull Item> items, int ... contentListSlots) {
        return new PagedItemsGuiImpl(width, height, items, contentListSlots);
    }

    @NotNull
    public static @NotNull PagedGui<@NotNull Item> ofItems(@NotNull Structure structure, @NotNull @NotNull List<@NotNull Item> items) {
        return new PagedItemsGuiImpl(items, structure);
    }

    @NotNull
    public static @NotNull Builder<@NotNull Gui> guis() {
        return new PagedNestedGuiImpl.Builder();
    }

    @NotNull
    public static @NotNull PagedGui<@NotNull Gui> guis(@NotNull @NotNull Consumer<@NotNull Builder<@NotNull Gui>> consumer) {
        Builder<Gui> builder = PagedGui.guis();
        consumer.accept(builder);
        return (PagedGui)builder.build();
    }

    @NotNull
    public static @NotNull PagedGui<@NotNull Gui> ofGuis(int width, int height, @NotNull @NotNull List<@NotNull Gui> guis, int ... contentListSlots) {
        return new PagedNestedGuiImpl(width, height, guis, contentListSlots);
    }

    @NotNull
    public static @NotNull PagedGui<@NotNull Gui> ofGuis(@NotNull Structure structure, @NotNull @NotNull List<@NotNull Gui> guis) {
        return new PagedNestedGuiImpl(guis, structure);
    }

    @NotNull
    public static @NotNull Builder<@NotNull Inventory> inventories() {
        return new PagedInventoriesGuiImpl.Builder();
    }

    @NotNull
    public static @NotNull PagedGui<@NotNull Inventory> inventories(@NotNull @NotNull Consumer<@NotNull Builder<@NotNull Inventory>> consumer) {
        Builder<Inventory> builder = PagedGui.inventories();
        consumer.accept(builder);
        return (PagedGui)builder.build();
    }

    @NotNull
    public static @NotNull PagedGui<@NotNull Inventory> ofInventories(int width, int height, @NotNull @NotNull List<@NotNull Inventory> inventories, int ... contentListSlots) {
        return new PagedInventoriesGuiImpl(width, height, inventories, contentListSlots);
    }

    @NotNull
    public static @NotNull PagedGui<@NotNull Inventory> ofInventories(@NotNull Structure structure, @NotNull @NotNull List<@NotNull Inventory> inventories) {
        return new PagedInventoriesGuiImpl(inventories, structure);
    }

    public int getPageAmount();

    public int getCurrentPage();

    public void setPage(int var1);

    public boolean hasNextPage();

    public boolean hasPreviousPage();

    public boolean hasInfinitePages();

    public void goForward();

    public void goBack();

    public int[] getContentListSlots();

    public void setContent(@Nullable List<@NotNull C> var1);

    public void bake();

    public @Nullable List<@NotNull BiConsumer<Integer, Integer>> getPageChangeHandlers();

    public void setPageChangeHandlers(@Nullable List<@NotNull BiConsumer<Integer, Integer>> var1);

    public void addPageChangeHandler(@NotNull BiConsumer<Integer, Integer> var1);

    public void removePageChangeHandler(@NotNull BiConsumer<Integer, Integer> var1);

    public static interface Builder<C>
    extends Gui.Builder<PagedGui<C>, Builder<C>> {
        @Contract(value="_ -> this")
        @NotNull
        public Builder<C> setContent(@NotNull @NotNull List<@NotNull C> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder<C> addContent(@NotNull C var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder<C> setPageChangeHandlers(@NotNull @NotNull List<@NotNull BiConsumer<Integer, Integer>> var1);

        @Contract(value="_ -> this")
        @NotNull
        public Builder<C> addPageChangeHandler(@NotNull BiConsumer<Integer, Integer> var1);
    }
}

