/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.gui;

import com.thexfactor117.levels.bukkit.libs.invui.gui.AbstractPagedGui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.PagedGui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.SlotElement;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Structure;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.Inventory;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.VirtualInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class PagedInventoriesGuiImpl
extends AbstractPagedGui<Inventory> {
    @NotNull
    private final @NotNull BiConsumer<@NotNull Integer, @NotNull Integer> resizeHandler = (from, to) -> this.bake();

    public PagedInventoriesGuiImpl(int width, int height, @Nullable List<@NotNull Inventory> inventories, int ... contentListSlots) {
        super(width, height, false, contentListSlots);
        this.setContent(inventories);
    }

    public PagedInventoriesGuiImpl(@Nullable List<@NotNull Inventory> inventories, @NotNull Structure structure) {
        super(structure.getWidth(), structure.getHeight(), false, structure);
        this.setContent(inventories);
    }

    @Override
    public void setContent(@Nullable List<Inventory> content) {
        if (this.content != null) {
            for (Inventory inventory : this.content) {
                if (!(inventory instanceof VirtualInventory)) continue;
                ((VirtualInventory)inventory).removeResizeHandler(this.resizeHandler);
            }
        }
        super.setContent(content);
        if (this.content != null) {
            for (Inventory inventory : this.content) {
                if (!(inventory instanceof VirtualInventory)) continue;
                ((VirtualInventory)inventory).addResizeHandler(this.resizeHandler);
            }
        }
    }

    @Override
    public void bake() {
        int contentSize = this.getContentListSlots().length;
        ArrayList pages = new ArrayList();
        ArrayList<SlotElement.InventorySlotElement> page = new ArrayList<SlotElement.InventorySlotElement>(contentSize);
        for (Inventory inventory : this.content) {
            for (int slot = 0; slot < inventory.getSize(); ++slot) {
                page.add(new SlotElement.InventorySlotElement(inventory, slot));
                if (page.size() < contentSize) continue;
                pages.add(page);
                page = new ArrayList(contentSize);
            }
        }
        if (!page.isEmpty()) {
            pages.add(page);
        }
        this.pages = pages;
        this.update();
    }

    public static final class Builder
    extends AbstractPagedGui.AbstractBuilder<Inventory> {
        @Override
        @NotNull
        public PagedGui<Inventory> build() {
            if (this.structure == null) {
                throw new IllegalStateException("Structure is not defined.");
            }
            PagedInventoriesGuiImpl gui = new PagedInventoriesGuiImpl(this.content, this.structure);
            this.applyModifiers(gui);
            return gui;
        }
    }
}

