/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.gui;

import com.thexfactor117.levels.bukkit.libs.invui.gui.AbstractScrollGui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.ScrollGui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.SlotElement;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Structure;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.Inventory;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.VirtualInventory;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class ScrollInventoryGuiImpl
extends AbstractScrollGui<Inventory> {
    @NotNull
    private final @NotNull BiConsumer<@NotNull Integer, @NotNull Integer> resizeHandler = (from, to) -> this.bake();

    public ScrollInventoryGuiImpl(int width, int height, @Nullable List<@NotNull Inventory> inventories, int ... contentListSlots) {
        super(width, height, false, contentListSlots);
        this.setContent(inventories);
    }

    public ScrollInventoryGuiImpl(@Nullable List<@NotNull Inventory> inventories, @NotNull Structure structure) {
        super(structure.getWidth(), structure.getHeight(), false, structure);
        this.setContent(inventories);
    }

    @Override
    public void setContent(@Nullable List<Inventory> content) {
        if (this.content != null) {
            for (Inventory inventory : this.content) {
                if (!(inventory instanceof VirtualInventory)) continue;
                ((VirtualInventory)inventory).removeResizeHandler(this.resizeHandler);
            }
        }
        super.setContent(content);
        if (this.content != null) {
            for (Inventory inventory : this.content) {
                if (!(inventory instanceof VirtualInventory)) continue;
                ((VirtualInventory)inventory).addResizeHandler(this.resizeHandler);
            }
        }
    }

    @Override
    public void bake() {
        ArrayList<SlotElement.InventorySlotElement> elements = new ArrayList<SlotElement.InventorySlotElement>();
        for (Inventory inventory : this.content) {
            for (int i = 0; i < inventory.getSize(); ++i) {
                elements.add(new SlotElement.InventorySlotElement(inventory, i));
            }
        }
        this.elements = elements;
        this.update();
    }

    public static final class Builder
    extends AbstractScrollGui.AbstractBuilder<Inventory> {
        @Override
        @NotNull
        public ScrollGui<Inventory> build() {
            if (this.structure == null) {
                throw new IllegalStateException("Structure is not defined.");
            }
            ScrollInventoryGuiImpl gui = new ScrollInventoryGuiImpl(this.content, this.structure);
            this.applyModifiers(gui);
            return gui;
        }
    }
}

