/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.gui.structure;

import com.thexfactor117.levels.bukkit.libs.invui.gui.Gui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Ingredient;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Marker;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Markers;
import com.thexfactor117.levels.bukkit.libs.invui.util.SlotUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;

public class IngredientList
extends ArrayList<Ingredient> {
    private final int width;
    private final int height;

    public IngredientList(int width, int height, String structure, HashMap<Character, Ingredient> ingredientMap) {
        this.width = width;
        this.height = height;
        for (char c : structure.toCharArray()) {
            Ingredient ingredient = null;
            if (ingredientMap.containsKey(Character.valueOf(c))) {
                ingredient = ingredientMap.get(Character.valueOf(c));
            }
            this.add(ingredient);
        }
    }

    public void insertIntoGui(Gui gui) {
        if (this.size() != gui.getSize()) {
            throw new IllegalArgumentException("Structure size does not match Gui size");
        }
        for (int i = 0; i < this.size(); ++i) {
            Ingredient ingredient = (Ingredient)this.get(i);
            if (ingredient == null || !ingredient.isSlotElement()) continue;
            gui.setSlotElement(i, ingredient.getSlotElement());
        }
    }

    private List<Integer> findIndicesOfHorizontalMarker(Marker marker) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int i = 0; i < this.size(); ++i) {
            Ingredient ingredient = (Ingredient)this.get(i);
            if (ingredient == null || !ingredient.isMarker() || ingredient.getMarker() != marker) continue;
            indices.add(i);
        }
        return indices;
    }

    private List<Integer> findIndicesOfVerticalMarker(Marker marker) {
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (int x = 0; x < this.width; ++x) {
            for (int y = 0; y < this.height; ++y) {
                int i = SlotUtils.convertToIndex(x, y, this.width);
                Ingredient ingredient = (Ingredient)this.get(i);
                if (ingredient == null || !ingredient.isMarker() || ingredient.getMarker() != marker) continue;
                indices.add(i);
            }
        }
        return indices;
    }

    public int[] findIndicesOfMarker(Marker marker) {
        List<Integer> indices = marker.isHorizontal() ? this.findIndicesOfHorizontalMarker(marker) : this.findIndicesOfVerticalMarker(marker);
        return indices.stream().mapToInt(Integer::intValue).toArray();
    }

    public int[] findContentListSlots() {
        return Stream.concat(this.findIndicesOfHorizontalMarker(Markers.CONTENT_LIST_SLOT_HORIZONTAL).stream(), this.findIndicesOfVerticalMarker(Markers.CONTENT_LIST_SLOT_VERTICAL).stream()).mapToInt(Integer::intValue).toArray();
    }
}

