/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.gui.structure;

import com.thexfactor117.levels.bukkit.libs.invui.gui.SlotElement;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Ingredient;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.IngredientList;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.InventorySlotElementSupplier;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Marker;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.Inventory;
import com.thexfactor117.levels.bukkit.libs.invui.item.Item;
import com.thexfactor117.levels.bukkit.libs.invui.item.ItemProvider;
import com.thexfactor117.levels.bukkit.libs.invui.item.ItemWrapper;
import com.thexfactor117.levels.bukkit.libs.invui.item.impl.SimpleItem;
import java.util.HashMap;
import java.util.function.Supplier;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class Structure
implements Cloneable {
    private static final HashMap<Character, Ingredient> globalIngredientMap = new HashMap();
    private final String structureData;
    private final int width;
    private final int height;
    private HashMap<Character, Ingredient> ingredientMap = new HashMap();
    private IngredientList ingredientList;

    public Structure(String ... structureData) {
        this(Structure.sanitize(structureData[0]).length(), structureData.length, String.join((CharSequence)"", structureData));
    }

    public Structure(int width, int height, @NotNull String structureData) {
        this.width = width;
        this.height = height;
        this.structureData = Structure.sanitize(structureData);
        if (width * height != this.structureData.length()) {
            throw new IllegalArgumentException("Length of structure data does not match width * height");
        }
    }

    private static String sanitize(String s) {
        return s.replace(" ", "").replace("\n", "");
    }

    public static void addGlobalIngredient(char key, @NotNull ItemStack itemStack) {
        Structure.addGlobalIngredient(key, new ItemWrapper(itemStack));
    }

    public static void addGlobalIngredient(char key, @NotNull ItemProvider itemProvider) {
        Structure.addGlobalIngredient(key, new SimpleItem(itemProvider));
    }

    public static void addGlobalIngredient(char key, @NotNull Item item) {
        Structure.addGlobalIngredient(key, new SlotElement.ItemSlotElement(item));
    }

    public static void addGlobalIngredient(char key, @NotNull Supplier<? extends Item> itemSupplier) {
        Structure.addGlobalIngredientElementSupplier(key, () -> new SlotElement.ItemSlotElement((Item)itemSupplier.get()));
    }

    public static void addGlobalIngredient(char key, @NotNull SlotElement element) {
        globalIngredientMap.put(Character.valueOf(key), new Ingredient(element));
    }

    public static void addGlobalIngredient(char key, @NotNull Marker marker) {
        globalIngredientMap.put(Character.valueOf(key), new Ingredient(marker));
    }

    public static void addGlobalIngredientElementSupplier(char key, @NotNull Supplier<? extends SlotElement> elementSupplier) {
        globalIngredientMap.put(Character.valueOf(key), new Ingredient(elementSupplier));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public Structure addIngredient(char key, @NotNull ItemStack itemStack) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        return this.addIngredient(key, new ItemWrapper(itemStack));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public Structure addIngredient(char key, @NotNull ItemProvider itemProvider) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        return this.addIngredient(key, new SimpleItem(itemProvider));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public Structure addIngredient(char key, @NotNull Item item) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        return this.addIngredient(key, new SlotElement.ItemSlotElement(item));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public Structure addIngredient(char key, @NotNull Inventory inventory) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        return this.addIngredientElementSupplier(key, new InventorySlotElementSupplier(inventory));
    }

    @Contract(value="_, _, _ -> this")
    @NotNull
    public Structure addIngredient(char key, @NotNull Inventory inventory, @Nullable ItemProvider background) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        return this.addIngredientElementSupplier(key, new InventorySlotElementSupplier(inventory, background));
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public Structure addIngredient(char key, @NotNull SlotElement element) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        this.ingredientMap.put(Character.valueOf(key), new Ingredient(element));
        return this;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public Structure addIngredient(char key, @NotNull Marker marker) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        this.ingredientMap.put(Character.valueOf(key), new Ingredient(marker));
        return this;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public Structure addIngredient(char key, @NotNull Supplier<? extends Item> itemSupplier) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        this.ingredientMap.put(Character.valueOf(key), new Ingredient(() -> new SlotElement.ItemSlotElement((Item)itemSupplier.get())));
        return this;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public Structure addIngredientElementSupplier(char key, @NotNull Supplier<? extends SlotElement> elementSupplier) {
        if (this.ingredientList != null) {
            throw new IllegalStateException("Structure is locked");
        }
        this.ingredientMap.put(Character.valueOf(key), new Ingredient(elementSupplier));
        return this;
    }

    @NotNull
    public IngredientList getIngredientList() {
        if (this.ingredientList != null) {
            return this.ingredientList;
        }
        HashMap<Character, Ingredient> ingredients = new HashMap<Character, Ingredient>(globalIngredientMap);
        ingredients.putAll(this.ingredientMap);
        this.ingredientList = new IngredientList(this.width, this.height, this.structureData, ingredients);
        return this.ingredientList;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    @Contract(value="-> new", pure=true)
    @NotNull
    public Structure clone() {
        try {
            Structure clone = (Structure)super.clone();
            clone.ingredientMap = new HashMap<Character, Ingredient>(this.ingredientMap);
            clone.ingredientList = null;
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

