/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.inventory;

import com.thexfactor117.levels.bukkit.libs.invui.inventory.Inventory;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.event.ItemPostUpdateEvent;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.event.ItemPreUpdateEvent;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.event.UpdateReason;
import com.thexfactor117.levels.bukkit.libs.invui.util.Pair;
import java.util.Collection;
import java.util.function.Consumer;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompositeInventory
extends Inventory {
    private final Inventory[] inventories;

    public CompositeInventory(@NotNull Inventory first, Inventory ... other) {
        this.inventories = new Inventory[other.length + 1];
        this.inventories[0] = first;
        System.arraycopy(other, 0, this.inventories, 1, other.length);
    }

    public CompositeInventory(@NotNull @NotNull Collection<@NotNull Inventory> inventories) {
        if (inventories.isEmpty()) {
            throw new IllegalArgumentException("CompositeInventory must contain at least one Inventory");
        }
        this.inventories = (Inventory[])inventories.toArray(Inventory[]::new);
    }

    @Override
    public int getSize() {
        int size = 0;
        for (Inventory inventory : this.inventories) {
            size += inventory.getSize();
        }
        return size;
    }

    @Override
    public int @NotNull [] getMaxStackSizes() {
        int[] stackSizes = new int[this.getSize()];
        int pos = 0;
        for (Inventory inventory : this.inventories) {
            int[] otherStackSizes = inventory.getMaxStackSizes();
            System.arraycopy(otherStackSizes, 0, stackSizes, pos, otherStackSizes.length);
            pos += otherStackSizes.length;
        }
        return stackSizes;
    }

    @Override
    public int getMaxSlotStackSize(int slot) {
        Pair<Inventory, Integer> pair = this.findInventory(slot);
        return pair.getFirst().getMaxSlotStackSize(pair.getSecond());
    }

    @Override
    public @Nullable ItemStack @NotNull [] getItems() {
        ItemStack[] items = new ItemStack[this.getSize()];
        int pos = 0;
        for (Inventory inv : this.inventories) {
            ItemStack[] invItems = inv.getItems();
            System.arraycopy(invItems, 0, items, pos, invItems.length);
            pos += invItems.length;
        }
        return items;
    }

    @Override
    public @Nullable ItemStack @NotNull [] getUnsafeItems() {
        ItemStack[] items = new ItemStack[this.getSize()];
        int pos = 0;
        for (Inventory inv : this.inventories) {
            ItemStack[] invItems = inv.getUnsafeItems();
            System.arraycopy(invItems, 0, items, pos, invItems.length);
            pos += invItems.length;
        }
        return items;
    }

    @Override
    @Nullable
    public ItemStack getItem(int slot) {
        Pair<Inventory, Integer> pair = this.findInventory(slot);
        return pair.getFirst().getItem(pair.getSecond());
    }

    @Override
    @Nullable
    public ItemStack getUnsafeItem(int slot) {
        Pair<Inventory, Integer> pair = this.findInventory(slot);
        return pair.getFirst().getUnsafeItem(pair.getSecond());
    }

    @Override
    protected void setCloneBackingItem(int slot, @Nullable ItemStack itemStack) {
        Pair<Inventory, Integer> pair = this.findInventory(slot);
        pair.getFirst().setCloneBackingItem(pair.getSecond(), itemStack);
    }

    @Override
    protected void setDirectBackingItem(int slot, @Nullable ItemStack itemStack) {
        Pair<Inventory, Integer> pair = this.findInventory(slot);
        pair.getFirst().setDirectBackingItem(pair.getSecond(), itemStack);
    }

    private Pair<Inventory, Integer> findInventory(int slot) {
        int pos = 0;
        for (Inventory inv : this.inventories) {
            int invSize = inv.getSize();
            if (slot < pos + invSize) {
                return new Pair<Inventory, Integer>(inv, slot - pos);
            }
            pos += invSize;
        }
        throw new IndexOutOfBoundsException(slot);
    }

    @Override
    public void notifyWindows() {
        super.notifyWindows();
        for (Inventory inventory : this.inventories) {
            inventory.notifyWindows();
        }
    }

    @Override
    public ItemPreUpdateEvent callPreUpdateEvent(@Nullable UpdateReason updateReason, int slot, @Nullable ItemStack previousItemStack, @Nullable ItemStack newItemStack) {
        Pair<Inventory, Integer> invSlot = this.findInventory(slot);
        return invSlot.getFirst().callPreUpdateEvent(updateReason, invSlot.getSecond(), previousItemStack, newItemStack);
    }

    @Override
    public void callPostUpdateEvent(@Nullable UpdateReason updateReason, int slot, @Nullable ItemStack previousItemStack, @Nullable ItemStack newItemStack) {
        Pair<Inventory, Integer> invSlot = this.findInventory(slot);
        invSlot.getFirst().callPostUpdateEvent(updateReason, invSlot.getSecond(), previousItemStack, newItemStack);
    }

    @Override
    public boolean hasEventHandlers() {
        for (Inventory inventory : this.inventories) {
            if (!inventory.hasEventHandlers()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setPostUpdateHandler(@Nullable Consumer<@NotNull ItemPostUpdateEvent> inventoryUpdatedHandler) {
        throw new UnsupportedOperationException("Update handlers need to be set in the backing inventory");
    }

    @Override
    public void setPreUpdateHandler(@Nullable Consumer<@NotNull ItemPreUpdateEvent> preUpdateHandler) {
        throw new UnsupportedOperationException("Update handlers need to be set in the backing inventory");
    }
}

