/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.inventory;

import com.thexfactor117.levels.bukkit.libs.invui.inventory.Inventory;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.event.ItemPostUpdateEvent;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.event.ItemPreUpdateEvent;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.event.UpdateReason;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.function.IntPredicate;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ObscuredInventory
extends Inventory {
    @NotNull
    private final Inventory inventory;
    private final int @NotNull [] slots;

    public ObscuredInventory(@NotNull Inventory inventory, @NotNull IntPredicate isObscured) {
        this.inventory = inventory;
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (int slot = 0; slot < inventory.getSize(); ++slot) {
            if (isObscured.test(slot)) continue;
            slots.add(slot);
        }
        this.slots = slots.stream().mapToInt(Integer::intValue).toArray();
    }

    @Override
    public int getSize() {
        return this.slots.length;
    }

    @Override
    public int @NotNull [] getMaxStackSizes() {
        int[] maxStackSizes = new int[this.slots.length];
        for (int i = 0; i < this.slots.length; ++i) {
            maxStackSizes[i] = this.inventory.getMaxSlotStackSize(this.slots[i]);
        }
        return maxStackSizes;
    }

    @Override
    public int getMaxSlotStackSize(int slot) {
        return this.inventory.getMaxSlotStackSize(this.slots[slot]);
    }

    @Override
    public @Nullable ItemStack @NotNull [] getItems() {
        ItemStack[] items = new ItemStack[this.slots.length];
        for (int i = 0; i < this.slots.length; ++i) {
            items[i] = this.inventory.getItem(this.slots[i]);
        }
        return items;
    }

    @Override
    public @Nullable ItemStack @NotNull [] getUnsafeItems() {
        ItemStack[] items = new ItemStack[this.slots.length];
        for (int i = 0; i < this.slots.length; ++i) {
            items[i] = this.inventory.getUnsafeItem(this.slots[i]);
        }
        return items;
    }

    @Override
    @Nullable
    public ItemStack getItem(int slot) {
        return this.inventory.getItem(this.slots[slot]);
    }

    @Override
    @Nullable
    public ItemStack getUnsafeItem(int slot) {
        return this.inventory.getUnsafeItem(this.slots[slot]);
    }

    @Override
    protected void setCloneBackingItem(int slot, @Nullable ItemStack itemStack) {
        this.inventory.setCloneBackingItem(this.slots[slot], itemStack);
    }

    @Override
    protected void setDirectBackingItem(int slot, @Nullable ItemStack itemStack) {
        this.inventory.setDirectBackingItem(this.slots[slot], itemStack);
    }

    @Override
    public void notifyWindows() {
        super.notifyWindows();
        this.inventory.notifyWindows();
    }

    @Override
    public ItemPreUpdateEvent callPreUpdateEvent(@Nullable UpdateReason updateReason, int slot, @Nullable ItemStack previousItemStack, @Nullable ItemStack newItemStack) {
        return this.inventory.callPreUpdateEvent(updateReason, this.slots[slot], previousItemStack, newItemStack);
    }

    @Override
    public void callPostUpdateEvent(@Nullable UpdateReason updateReason, int slot, @Nullable ItemStack previousItemStack, @Nullable ItemStack newItemStack) {
        this.inventory.callPostUpdateEvent(updateReason, this.slots[slot], previousItemStack, newItemStack);
    }

    @Override
    public boolean hasEventHandlers() {
        return this.inventory.hasEventHandlers();
    }

    @Override
    public void setPostUpdateHandler(@Nullable Consumer<@NotNull ItemPostUpdateEvent> inventoryUpdatedHandler) {
        throw new UnsupportedOperationException("Update handlers need to be set in the backing inventory");
    }

    @Override
    public void setPreUpdateHandler(@Nullable Consumer<@NotNull ItemPreUpdateEvent> preUpdateHandler) {
        throw new UnsupportedOperationException("Update handlers need to be set in the backing inventory");
    }

    @Override
    public int getGuiPriority() {
        return this.inventory.getGuiPriority();
    }

    @Override
    public void setGuiPriority(int guiPriority) {
        throw new UnsupportedOperationException("Gui priority needs to be set in the backing inventory");
    }
}

