/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.inventory;

import com.thexfactor117.levels.bukkit.libs.invui.inventory.Inventory;
import com.thexfactor117.levels.bukkit.libs.invui.util.TriConsumer;
import java.util.Arrays;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReferencingInventory
extends Inventory {
    private static final int MAX_STACK_SIZE = 64;
    @NotNull
    protected final org.bukkit.inventory.Inventory inventory;
    @NotNull
    protected final @NotNull Function<@NotNull org.bukkit.inventory.Inventory, @Nullable ItemStack @NotNull []> itemsGetter;
    @NotNull
    protected final @NotNull BiFunction<@NotNull org.bukkit.inventory.Inventory, @NotNull Integer, @Nullable ItemStack> itemGetter;
    @NotNull
    protected final @NotNull TriConsumer<@NotNull org.bukkit.inventory.Inventory, @NotNull Integer, @Nullable ItemStack> itemSetter;
    protected final int size;
    protected final int @NotNull [] maxStackSizes;

    public ReferencingInventory(@NotNull org.bukkit.inventory.Inventory inventory, @NotNull @NotNull Function<@NotNull org.bukkit.inventory.Inventory, @Nullable ItemStack @NotNull []> itemsGetter, @NotNull @NotNull BiFunction<@NotNull org.bukkit.inventory.Inventory, @NotNull Integer, @Nullable ItemStack> itemGetter, @NotNull @NotNull TriConsumer<@NotNull org.bukkit.inventory.Inventory, @NotNull Integer, @Nullable ItemStack> itemSetter) {
        this.inventory = inventory;
        this.itemsGetter = itemsGetter;
        this.itemGetter = itemGetter;
        this.itemSetter = itemSetter;
        this.size = itemsGetter.apply(inventory).length;
        this.maxStackSizes = new int[this.size];
        Arrays.fill(this.maxStackSizes, 64);
    }

    @NotNull
    public static ReferencingInventory fromStorageContents(@NotNull org.bukkit.inventory.Inventory inventory) {
        return new ReferencingInventory(inventory, org.bukkit.inventory.Inventory::getStorageContents, org.bukkit.inventory.Inventory::getItem, org.bukkit.inventory.Inventory::setItem);
    }

    @NotNull
    public static ReferencingInventory fromContents(@NotNull org.bukkit.inventory.Inventory inventory) {
        return new ReferencingInventory(inventory, org.bukkit.inventory.Inventory::getContents, org.bukkit.inventory.Inventory::getItem, org.bukkit.inventory.Inventory::setItem);
    }

    @NotNull
    public static ReferencingInventory fromReversedPlayerStorageContents(@NotNull PlayerInventory inventory) {
        return new ReversedPlayerContents(inventory);
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int @NotNull [] getMaxStackSizes() {
        return (int[])this.maxStackSizes.clone();
    }

    @Override
    public int getMaxSlotStackSize(int slot) {
        return 64;
    }

    @Override
    public @Nullable ItemStack @NotNull [] getItems() {
        return this.itemsGetter.apply(this.inventory);
    }

    @Override
    public @Nullable ItemStack @NotNull [] getUnsafeItems() {
        return this.itemsGetter.apply(this.inventory);
    }

    @Override
    @Nullable
    public ItemStack getItem(int slot) {
        return this.itemGetter.apply(this.inventory, slot);
    }

    @Override
    @Nullable
    public ItemStack getUnsafeItem(int slot) {
        return this.itemGetter.apply(this.inventory, slot);
    }

    @Override
    protected void setCloneBackingItem(int slot, @Nullable ItemStack itemStack) {
        this.itemSetter.accept(this.inventory, slot, itemStack);
    }

    @Override
    protected void setDirectBackingItem(int slot, @Nullable ItemStack itemStack) {
        this.itemSetter.accept(this.inventory, slot, itemStack);
    }

    private static class ReversedPlayerContents
    extends ReferencingInventory {
        public ReversedPlayerContents(PlayerInventory inventory) {
            super((org.bukkit.inventory.Inventory)inventory, org.bukkit.inventory.Inventory::getStorageContents, org.bukkit.inventory.Inventory::getItem, org.bukkit.inventory.Inventory::setItem);
        }

        private int convertSlot(int invUiSlot) {
            if (invUiSlot < 9) {
                return 8 - invUiSlot;
            }
            return 44 - invUiSlot;
        }

        @Override
        @Nullable
        public ItemStack getItem(int slot) {
            return super.getItem(this.convertSlot(slot));
        }

        @Override
        @Nullable
        public ItemStack getUnsafeItem(int slot) {
            return super.getUnsafeItem(this.convertSlot(slot));
        }

        @Override
        public @Nullable ItemStack @NotNull [] getUnsafeItems() {
            return this.getItems();
        }

        @Override
        public @Nullable ItemStack @NotNull [] getItems() {
            int i;
            ItemStack[] items = (ItemStack[])this.itemsGetter.apply(this.inventory);
            ItemStack[] reorderedItems = new ItemStack[items.length];
            for (i = 0; i < 9; ++i) {
                reorderedItems[8 - i] = items[i];
            }
            for (i = 9; i < 36; ++i) {
                reorderedItems[44 - i] = items[i];
            }
            return reorderedItems;
        }

        @Override
        protected void setCloneBackingItem(int slot, @Nullable ItemStack itemStack) {
            super.setCloneBackingItem(this.convertSlot(slot), itemStack);
        }

        @Override
        protected void setDirectBackingItem(int slot, @Nullable ItemStack itemStack) {
            super.setDirectBackingItem(this.convertSlot(slot), itemStack);
        }
    }
}

