/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.inventory;

import com.thexfactor117.levels.bukkit.libs.inventoryaccess.InventoryAccess;
import com.thexfactor117.levels.bukkit.libs.invui.InvUI;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.Inventory;
import com.thexfactor117.levels.bukkit.libs.invui.util.DataUtils;
import com.thexfactor117.levels.bukkit.libs.invui.util.ItemUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualInventory
extends Inventory {
    @NotNull
    private final UUID uuid;
    private int size;
    private @Nullable ItemStack @NotNull [] items;
    private int @NotNull [] maxStackSizes;
    private @Nullable List<@NotNull BiConsumer<@NotNull Integer, @NotNull Integer>> resizeHandlers;

    public VirtualInventory(@Nullable UUID uuid, int size, @Nullable @Nullable ItemStack @Nullable [] items, int @Nullable [] maxStackSizes) {
        this.uuid = uuid == null ? new UUID(0L, 0L) : uuid;
        this.size = size;
        ItemStack[] itemStackArray = this.items = items == null ? new ItemStack[size] : items;
        if (maxStackSizes == null) {
            this.maxStackSizes = new int[size];
            Arrays.fill(this.maxStackSizes, 64);
        } else {
            this.maxStackSizes = maxStackSizes;
        }
        if (size != this.items.length) {
            throw new IllegalArgumentException("Inventory size does not match items array length");
        }
        if (size != this.maxStackSizes.length) {
            throw new IllegalArgumentException("Inventory size does not match maxStackSizes array length");
        }
        if (items != null) {
            for (ItemStack item : items) {
                if (item == null || item.getType() != Material.AIR) continue;
                throw new IllegalArgumentException("Items array may not contain air items!");
            }
        }
    }

    public VirtualInventory(int size, @Nullable @Nullable ItemStack @Nullable [] items, int @Nullable [] maxStackSizes) {
        this(null, size, items, maxStackSizes);
    }

    public VirtualInventory(@Nullable UUID uuid, @Nullable ItemStack @NotNull [] items, int @Nullable [] maxStackSizes) {
        this(uuid, items.length, items, maxStackSizes);
    }

    public VirtualInventory(@Nullable ItemStack @NotNull [] items, int @Nullable [] maxStackSizes) {
        this(null, items.length, items, maxStackSizes);
    }

    public VirtualInventory(@Nullable UUID uuid, @Nullable ItemStack @NotNull [] items) {
        this(uuid, items.length, items, null);
    }

    public VirtualInventory(@Nullable ItemStack @NotNull [] items) {
        this(null, items.length, items, null);
    }

    public VirtualInventory(@Nullable UUID uuid, int @NotNull [] maxStackSizes) {
        this(uuid, maxStackSizes.length, null, maxStackSizes);
    }

    public VirtualInventory(int @NotNull [] maxStackSizes) {
        this(null, maxStackSizes.length, null, maxStackSizes);
    }

    public VirtualInventory(@Nullable UUID uuid, int size) {
        this(uuid, size, null, null);
    }

    public VirtualInventory(int size) {
        this(null, size, null, null);
    }

    public VirtualInventory(VirtualInventory inventory) {
        this(inventory.uuid, inventory.size, ItemUtils.clone(inventory.items), (int[])inventory.maxStackSizes.clone());
        this.setGuiPriority(inventory.getGuiPriority());
        this.setPreUpdateHandler(inventory.getPreUpdateHandler());
        this.setPostUpdateHandler(inventory.getPostUpdateHandler());
        this.setResizeHandlers(inventory.getResizeHandlers());
    }

    public static VirtualInventory deserialize(byte[] bytes) {
        return VirtualInventory.deserialize(new ByteArrayInputStream(bytes));
    }

    public static VirtualInventory deserialize(InputStream in) {
        try {
            DataInputStream din = new DataInputStream(in);
            UUID uuid = new UUID(din.readLong(), din.readLong());
            byte id = din.readByte();
            if (id == 3) {
                DataUtils.readByteArray(din);
            }
            ItemStack[] items = (ItemStack[])Arrays.stream(DataUtils.read2DByteArray(din)).map(data -> {
                if (((byte[])data).length != 0) {
                    return InventoryAccess.getItemUtils().deserializeItemStack((byte[])data, true);
                }
                return null;
            }).toArray(ItemStack[]::new);
            return new VirtualInventory(uuid, items);
        }
        catch (IOException e) {
            InvUI.getInstance().getLogger().log(Level.SEVERE, "Failed to deserialize VirtualInventory", e);
            return null;
        }
    }

    public byte[] serialize() {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.serialize(out);
        return out.toByteArray();
    }

    public void serialize(OutputStream out) {
        try {
            DataOutputStream dos = new DataOutputStream(out);
            dos.writeLong(this.uuid.getMostSignificantBits());
            dos.writeLong(this.uuid.getLeastSignificantBits());
            dos.writeByte(4);
            byte[][] items = (byte[][])Arrays.stream(this.items).map(itemStack -> {
                if (itemStack != null) {
                    return InventoryAccess.getItemUtils().serializeItemStack((ItemStack)itemStack, true);
                }
                return new byte[0];
            }).toArray(x$0 -> new byte[x$0][]);
            DataUtils.write2DByteArray(dos, items);
            dos.flush();
        }
        catch (IOException e) {
            InvUI.getInstance().getLogger().log(Level.SEVERE, "Failed to serialize VirtualInventory", e);
        }
    }

    public void setResizeHandlers(@Nullable List<@NotNull BiConsumer<@NotNull Integer, @NotNull Integer>> resizeHandlers) {
        this.resizeHandlers = resizeHandlers;
    }

    public @Nullable List<@NotNull BiConsumer<@NotNull Integer, @NotNull Integer>> getResizeHandlers() {
        return this.resizeHandlers;
    }

    public void addResizeHandler(@NotNull @NotNull BiConsumer<@NotNull Integer, @NotNull Integer> resizeHandler) {
        if (this.resizeHandlers == null) {
            this.resizeHandlers = new ArrayList<BiConsumer<Integer, Integer>>();
        }
        this.resizeHandlers.add(resizeHandler);
    }

    public void removeResizeHandler(@NotNull @NotNull BiConsumer<@NotNull Integer, @NotNull Integer> resizeHandler) {
        if (this.resizeHandlers != null) {
            this.resizeHandlers.remove(resizeHandler);
        }
    }

    public void resize(int size) {
        if (this.size == size) {
            return;
        }
        int previousSize = this.size;
        this.size = size;
        this.items = Arrays.copyOf(this.items, size);
        this.maxStackSizes = Arrays.copyOf(this.maxStackSizes, size);
        if (size > previousSize) {
            int stackSize = previousSize != 0 ? this.maxStackSizes[previousSize - 1] : 64;
            Arrays.fill(this.maxStackSizes, previousSize, this.maxStackSizes.length, stackSize);
        }
        if (this.resizeHandlers != null) {
            for (BiConsumer<Integer, Integer> resizeHandler : this.resizeHandlers) {
                resizeHandler.accept(previousSize, size);
            }
        }
    }

    public void setMaxStackSizes(int @NotNull [] stackSizes) {
        this.maxStackSizes = stackSizes;
    }

    public void setMaxStackSize(int slot, int maxStackSize) {
        this.maxStackSizes[slot] = maxStackSize;
    }

    @NotNull
    public UUID getUuid() {
        return this.uuid;
    }

    @Override
    public int getSize() {
        return this.size;
    }

    @Override
    public int @NotNull [] getMaxStackSizes() {
        return (int[])this.maxStackSizes.clone();
    }

    @Override
    public int getMaxSlotStackSize(int slot) {
        return this.maxStackSizes[slot];
    }

    @Override
    public @Nullable ItemStack @NotNull [] getItems() {
        return ItemUtils.clone(this.items);
    }

    @Override
    public @Nullable ItemStack @NotNull [] getUnsafeItems() {
        return this.items;
    }

    @Override
    @Nullable
    public ItemStack getItem(int slot) {
        ItemStack itemStack = this.items[slot];
        return itemStack != null ? itemStack.clone() : null;
    }

    @Override
    public ItemStack getUnsafeItem(int slot) {
        return this.items[slot];
    }

    @Override
    protected void setCloneBackingItem(int slot, @Nullable ItemStack itemStack) {
        this.items[slot] = itemStack != null ? itemStack.clone() : null;
    }

    @Override
    protected void setDirectBackingItem(int slot, @Nullable ItemStack itemStack) {
        this.items[slot] = itemStack;
    }
}

