/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.inventory.event;

import com.thexfactor117.levels.bukkit.libs.invui.inventory.Inventory;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.event.UpdateReason;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

abstract class ItemUpdateEvent {
    private final Inventory inventory;
    private final UpdateReason updateReason;
    private final int slot;
    private final ItemStack previousItemStack;
    protected ItemStack newItemStack;

    public ItemUpdateEvent(@NotNull Inventory inventory, int slot, @Nullable UpdateReason updateReason, @Nullable ItemStack previousItem, @Nullable ItemStack newItem) {
        this.inventory = inventory;
        this.slot = slot;
        this.updateReason = updateReason;
        this.previousItemStack = previousItem;
        this.newItemStack = newItem;
    }

    @NotNull
    public Inventory getInventory() {
        return this.inventory;
    }

    @Nullable
    public UpdateReason getUpdateReason() {
        return this.updateReason;
    }

    @Nullable
    public ItemStack getPreviousItem() {
        return this.previousItemStack;
    }

    @Nullable
    public ItemStack getNewItem() {
        return this.newItemStack;
    }

    public int getSlot() {
        return this.slot;
    }

    public boolean isAdd() {
        if (this.newItemStack != null && this.previousItemStack != null && this.newItemStack.isSimilar(this.previousItemStack)) {
            return this.newItemStack.getAmount() > this.previousItemStack.getAmount();
        }
        return this.previousItemStack == null && this.newItemStack != null;
    }

    public boolean isRemove() {
        if (this.newItemStack != null && this.previousItemStack != null && this.newItemStack.isSimilar(this.previousItemStack)) {
            return this.newItemStack.getAmount() < this.previousItemStack.getAmount();
        }
        return this.newItemStack == null && this.previousItemStack != null;
    }

    public boolean isSwap() {
        return this.newItemStack != null && this.previousItemStack != null && !this.newItemStack.isSimilar(this.previousItemStack);
    }

    public int getRemovedAmount() {
        if (!this.isRemove()) {
            throw new IllegalStateException("No items have been removed");
        }
        if (this.newItemStack == null) {
            return this.previousItemStack.getAmount();
        }
        return this.previousItemStack.getAmount() - this.newItemStack.getAmount();
    }

    public int getAddedAmount() {
        if (!this.isAdd()) {
            throw new IllegalStateException("No items have been added");
        }
        if (this.previousItemStack == null) {
            return this.newItemStack.getAmount();
        }
        return this.newItemStack.getAmount() - this.previousItemStack.getAmount();
    }
}

