/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.item.builder;

import com.thexfactor117.levels.bukkit.libs.invui.item.builder.AbstractItemBuilder;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.DyeColor;
import org.bukkit.Material;
import org.bukkit.block.banner.Pattern;
import org.bukkit.block.banner.PatternType;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class BannerBuilder
extends AbstractItemBuilder<BannerBuilder> {
    private List<Pattern> patterns = new ArrayList<Pattern>();

    public BannerBuilder(@NotNull Material material) {
        super(material);
    }

    public BannerBuilder(@NotNull Material material, int amount) {
        super(material, amount);
    }

    public BannerBuilder(@NotNull ItemStack base) {
        super(base);
    }

    @Contract(value="_ -> this")
    @NotNull
    public BannerBuilder addPattern(@NotNull Pattern pattern) {
        this.patterns.add(pattern);
        return this;
    }

    @Contract(value="_, _ -> this")
    @NotNull
    public BannerBuilder addPattern(@NotNull DyeColor color, @NotNull PatternType type) {
        this.patterns.add(new Pattern(color, type));
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public BannerBuilder setPatterns(@NotNull @NotNull List<@NotNull Pattern> patterns) {
        this.patterns = patterns;
        return this;
    }

    @Contract(value="-> this")
    @NotNull
    public BannerBuilder clearPatterns() {
        this.patterns.clear();
        return this;
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public ItemStack get(@Nullable String lang) {
        ItemStack item = super.get(lang);
        BannerMeta meta = (BannerMeta)item.getItemMeta();
        meta.setPatterns(this.patterns);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    @Override
    @NotNull
    public BannerBuilder clone() {
        BannerBuilder builder = (BannerBuilder)super.clone();
        builder.patterns = new ArrayList<Pattern>(this.patterns);
        return builder;
    }
}

