/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.item.builder;

import com.thexfactor117.levels.bukkit.libs.invui.item.builder.AbstractItemBuilder;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.FireworkEffect;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Range;

public final class FireworkBuilder
extends AbstractItemBuilder<FireworkBuilder> {
    private int power = -1;
    private List<FireworkEffect> effects = new ArrayList<FireworkEffect>();

    public FireworkBuilder() {
        super(Material.FIREWORK_ROCKET);
    }

    public FireworkBuilder(int amount) {
        super(Material.FIREWORK_ROCKET, amount);
    }

    public FireworkBuilder(@NotNull ItemStack base) {
        super(base);
    }

    @Contract(value="_ -> this")
    @NotNull
    public FireworkBuilder setPower(@Range(from=0L, to=127L) int power) {
        this.power = power;
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public FireworkBuilder addFireworkEffect(@NotNull FireworkEffect effect) {
        this.effects.add(effect);
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public FireworkBuilder addFireworkEffect(@NotNull FireworkEffect.Builder builder) {
        this.effects.add(builder.build());
        return this;
    }

    @Contract(value="_ -> this")
    @NotNull
    public FireworkBuilder setFireworkEffects(@NotNull @NotNull List<@NotNull FireworkEffect> effects) {
        this.effects = effects;
        return this;
    }

    @Contract(value="-> this")
    @NotNull
    public FireworkBuilder clearFireworkEffects() {
        this.effects.clear();
        return this;
    }

    @Override
    @Contract(value="_ -> new", pure=true)
    @NotNull
    public ItemStack get(@Nullable String lang) {
        ItemStack item = super.get(lang);
        FireworkMeta meta = (FireworkMeta)item.getItemMeta();
        if (this.power != -1) {
            meta.setPower(this.power);
        }
        meta.clearEffects();
        meta.addEffects(this.effects);
        item.setItemMeta((ItemMeta)meta);
        return item;
    }

    @Override
    @NotNull
    public FireworkBuilder clone() {
        FireworkBuilder builder = (FireworkBuilder)super.clone();
        builder.effects = new ArrayList<FireworkEffect>(this.effects);
        return builder;
    }
}

