/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.item.impl;

import com.thexfactor117.levels.bukkit.libs.invui.InvUI;
import com.thexfactor117.levels.bukkit.libs.invui.item.ItemProvider;
import com.thexfactor117.levels.bukkit.libs.invui.item.impl.SuppliedItem;
import com.thexfactor117.levels.bukkit.libs.invui.window.AbstractWindow;
import java.util.function.Supplier;
import org.bukkit.Bukkit;
import org.bukkit.scheduler.BukkitTask;

public class AutoUpdateItem
extends SuppliedItem {
    private final int period;
    private BukkitTask task;

    public AutoUpdateItem(int period, Supplier<? extends ItemProvider> builderSupplier) {
        super(builderSupplier, null);
        this.period = period;
    }

    public void start() {
        if (this.task != null) {
            this.task.cancel();
        }
        this.task = Bukkit.getScheduler().runTaskTimer(InvUI.getInstance().getPlugin(), this::notifyWindows, 0L, (long)this.period);
    }

    public void cancel() {
        this.task.cancel();
        this.task = null;
    }

    @Override
    public void addWindow(AbstractWindow window) {
        super.addWindow(window);
        if (this.task == null) {
            this.start();
        }
    }

    @Override
    public void removeWindow(AbstractWindow window) {
        super.removeWindow(window);
        if (this.getWindows().isEmpty() && this.task != null) {
            this.cancel();
        }
    }
}

