/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.window;

import com.thexfactor117.levels.bukkit.libs.inventoryaccess.InventoryAccess;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.ComponentWrapper;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.util.VersionUtils;
import com.thexfactor117.levels.bukkit.libs.invui.gui.AbstractGui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.SlotElement;
import com.thexfactor117.levels.bukkit.libs.invui.util.Pair;
import com.thexfactor117.levels.bukkit.libs.invui.util.SlotUtils;
import com.thexfactor117.levels.bukkit.libs.invui.window.AbstractWindow;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractDoubleWindow
extends AbstractWindow {
    private final Inventory playerInventory;
    private final ItemStack[] playerItems = new ItemStack[36];
    protected Inventory upperInventory;

    public AbstractDoubleWindow(Player player, ComponentWrapper title, int size, Inventory upperInventory, boolean closeable) {
        super(player, title, size, closeable);
        this.upperInventory = upperInventory;
        this.playerInventory = player.getInventory();
    }

    @Override
    protected void initItems() {
        int i;
        for (int i2 = 0; i2 < this.upperInventory.getSize(); ++i2) {
            SlotElement element = this.getSlotElement(i2);
            this.redrawItem(i2, element, true);
        }
        PlayerInventory inventory = this.getViewer().getInventory();
        for (i = 0; i < 36; ++i) {
            this.playerItems[i] = inventory.getItem(i);
            inventory.setItem(i, null);
        }
        for (i = this.upperInventory.getSize(); i < this.upperInventory.getSize() + 36; ++i) {
            SlotElement element = this.getSlotElement(i);
            this.redrawItem(i, element, true);
        }
    }

    @Override
    @Nullable
    public @Nullable ItemStack @Nullable [] getPlayerItems() {
        if (this.isOpen()) {
            return this.playerItems;
        }
        return null;
    }

    private void restorePlayerInventory() {
        PlayerInventory inventory = this.getViewer().getInventory();
        for (int i = 0; i < 36; ++i) {
            inventory.setItem(i, this.playerItems[i]);
        }
    }

    @Override
    protected void redrawItem(int index, SlotElement element, boolean setItem) {
        super.redrawItem(index, element, setItem);
        if (this.isOpen() && !VersionUtils.isServerHigherOrEqual(1, 17, 0)) {
            this.getViewer().updateInventory();
        }
    }

    @Override
    protected void setInvItem(int slot, ItemStack itemStack) {
        if (slot >= this.upperInventory.getSize()) {
            if (this.isOpen()) {
                int invSlot = SlotUtils.translateGuiToPlayerInv(slot - this.upperInventory.getSize());
                this.setPlayerInvItem(invSlot, itemStack);
            }
        } else {
            this.setUpperInvItem(slot, itemStack);
        }
    }

    protected void setUpperInvItem(int slot, ItemStack itemStack) {
        this.upperInventory.setItem(slot, itemStack);
    }

    protected void setPlayerInvItem(int slot, ItemStack itemStack) {
        this.playerInventory.setItem(slot, itemStack);
    }

    @Override
    public void handleViewerDeath(PlayerDeathEvent event) {
        if (this.isOpen()) {
            List drops = event.getDrops();
            if (!event.getKeepInventory()) {
                drops.clear();
                Arrays.stream(this.playerItems).filter(Objects::nonNull).forEach(drops::add);
            }
        }
    }

    @Override
    protected void handleOpened() {
        InventoryAccess.getPlayerUtils().stopAdvancementListening(this.getViewer());
    }

    @Override
    protected void handleClosed() {
        this.restorePlayerInventory();
        InventoryAccess.getPlayerUtils().startAdvancementListening(this.getViewer());
    }

    @Override
    public void handleClick(InventoryClickEvent event) {
        Pair<AbstractGui, Integer> clicked = this.getWhereClicked(event);
        clicked.getFirst().handleClick(clicked.getSecond(), (Player)event.getWhoClicked(), event.getClick(), event);
    }

    @Override
    public void handleItemShift(InventoryClickEvent event) {
    }

    @Override
    public Inventory[] getInventories() {
        Inventory[] inventoryArray;
        if (this.isOpen()) {
            Inventory[] inventoryArray2 = new Inventory[2];
            inventoryArray2[0] = this.upperInventory;
            inventoryArray = inventoryArray2;
            inventoryArray2[1] = this.playerInventory;
        } else {
            Inventory[] inventoryArray3 = new Inventory[1];
            inventoryArray = inventoryArray3;
            inventoryArray3[0] = this.upperInventory;
        }
        return inventoryArray;
    }

    public Inventory getUpperInventory() {
        return this.upperInventory;
    }

    public Inventory getPlayerInventory() {
        return this.playerInventory;
    }

    protected abstract Pair<AbstractGui, Integer> getWhereClicked(InventoryClickEvent var1);
}

