/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.window;

import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.ComponentWrapper;
import com.thexfactor117.levels.bukkit.libs.invui.gui.AbstractGui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.Gui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.SlotElement;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.Inventory;
import com.thexfactor117.levels.bukkit.libs.invui.inventory.ReferencingInventory;
import com.thexfactor117.levels.bukkit.libs.invui.util.Pair;
import com.thexfactor117.levels.bukkit.libs.invui.window.AbstractWindow;
import com.thexfactor117.levels.bukkit.libs.invui.window.Window;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import org.bukkit.entity.Player;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractSingleWindow
extends AbstractWindow {
    private final AbstractGui gui;
    private final int size;
    protected org.bukkit.inventory.Inventory inventory;

    public AbstractSingleWindow(Player viewer, ComponentWrapper title, AbstractGui gui, org.bukkit.inventory.Inventory inventory, boolean closeable) {
        super(viewer, title, gui.getSize(), closeable);
        this.gui = gui;
        this.size = gui.getSize();
        this.inventory = inventory;
    }

    @Override
    protected void initItems() {
        for (int i = 0; i < this.size; ++i) {
            SlotElement element = this.gui.getSlotElement(i);
            this.redrawItem(i, element, true);
        }
    }

    @Override
    protected void setInvItem(int slot, ItemStack itemStack) {
        this.inventory.setItem(slot, itemStack);
    }

    @Override
    protected void handleOpened() {
    }

    @Override
    protected void handleClosed() {
    }

    @Override
    public void handleSlotElementUpdate(Gui child, int slotIndex) {
        this.redrawItem(slotIndex, this.gui.getSlotElement(slotIndex), true);
    }

    @Override
    public void handleClick(InventoryClickEvent event) {
        this.gui.handleClick(event.getSlot(), (Player)event.getWhoClicked(), event.getClick(), event);
    }

    @Override
    public void handleItemShift(InventoryClickEvent event) {
        this.gui.handleItemShift(event);
    }

    @Override
    protected List<Inventory> getContentInventories() {
        ArrayList<Inventory> inventories = new ArrayList<Inventory>(this.gui.getAllInventories(new Inventory[0]));
        inventories.add(ReferencingInventory.fromStorageContents((org.bukkit.inventory.Inventory)this.getViewer().getInventory()));
        return inventories;
    }

    @Override
    protected Pair<AbstractGui, Integer> getGuiAt(int index) {
        return index < this.gui.getSize() ? new Pair<AbstractGui, Integer>(this.gui, index) : null;
    }

    @Override
    protected SlotElement getSlotElement(int index) {
        return this.gui.getSlotElement(index);
    }

    @Override
    public void handleViewerDeath(PlayerDeathEvent event) {
    }

    @Override
    public org.bukkit.inventory.Inventory[] getInventories() {
        return new org.bukkit.inventory.Inventory[]{this.inventory};
    }

    @Override
    public AbstractGui[] getGuis() {
        return new AbstractGui[]{this.gui};
    }

    public AbstractGui getGui() {
        return this.gui;
    }

    @Override
    @Nullable
    public @Nullable ItemStack @Nullable [] getPlayerItems() {
        Player viewer = this.getCurrentViewer();
        if (viewer != null) {
            return viewer.getInventory().getContents();
        }
        return null;
    }

    public static abstract class AbstractBuilder<W extends Window, S extends Window.Builder.Single<W, S>>
    extends AbstractWindow.AbstractBuilder<W, S>
    implements Window.Builder.Single<W, S> {
        protected Supplier<Gui> guiSupplier;

        @Override
        @NotNull
        public S setGui(@NotNull Supplier<Gui> guiSupplier) {
            this.guiSupplier = guiSupplier;
            return (S)this;
        }

        @Override
        @NotNull
        public S setGui(@NotNull Gui gui) {
            this.guiSupplier = () -> gui;
            return (S)this;
        }

        @Override
        @NotNull
        public S setGui(@NotNull Gui.Builder<?, ?> builder) {
            this.guiSupplier = builder::build;
            return (S)this;
        }
    }
}

