/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.window;

import com.thexfactor117.levels.bukkit.libs.inventoryaccess.InventoryAccess;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.abstraction.inventory.AnvilInventory;
import com.thexfactor117.levels.bukkit.libs.inventoryaccess.component.ComponentWrapper;
import com.thexfactor117.levels.bukkit.libs.invui.gui.AbstractGui;
import com.thexfactor117.levels.bukkit.libs.invui.window.AbstractSplitWindow;
import com.thexfactor117.levels.bukkit.libs.invui.window.AnvilWindow;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class AnvilSplitWindowImpl
extends AbstractSplitWindow
implements AnvilWindow {
    private final AnvilInventory anvilInventory;

    public AnvilSplitWindowImpl(@NotNull Player player, @Nullable ComponentWrapper title, @NotNull AbstractGui upperGui, @NotNull AbstractGui lowerGui, @Nullable List<@NotNull Consumer<@NotNull String>> renameHandlers, boolean closeable) {
        super(player, title, upperGui, lowerGui, null, closeable);
        this.anvilInventory = InventoryAccess.createAnvilInventory(player, title != null ? title.localized(player) : null, renameHandlers);
        this.upperInventory = this.anvilInventory.getBukkitInventory();
    }

    @Override
    protected void setUpperInvItem(int slot, ItemStack itemStack) {
        this.anvilInventory.setItem(slot, itemStack);
    }

    @Override
    protected void openInventory(@NotNull Player viewer) {
        this.anvilInventory.open();
    }

    @Override
    public String getRenameText() {
        return this.anvilInventory.getRenameText();
    }

    public static final class BuilderImpl
    extends AbstractSplitWindow.AbstractBuilder<AnvilWindow, AnvilWindow.Builder.Split>
    implements AnvilWindow.Builder.Split {
        private List<Consumer<String>> renameHandlers;

        @Override
        @NotNull
        public BuilderImpl setRenameHandlers(@NotNull @NotNull List<@NotNull Consumer<String>> renameHandlers) {
            this.renameHandlers = renameHandlers;
            return this;
        }

        @Override
        @NotNull
        public BuilderImpl addRenameHandler(@NotNull Consumer<String> renameHandler) {
            if (this.renameHandlers == null) {
                this.renameHandlers = new ArrayList<Consumer<String>>();
            }
            this.renameHandlers.add(renameHandler);
            return this;
        }

        @Override
        @NotNull
        public AnvilWindow build(Player viewer) {
            if (viewer == null) {
                throw new IllegalStateException("Viewer is not defined.");
            }
            if (this.upperGuiSupplier == null) {
                throw new IllegalStateException("Upper Gui is not defined.");
            }
            if (this.lowerGuiSupplier == null) {
                throw new IllegalStateException("Lower Gui is not defined.");
            }
            AnvilSplitWindowImpl window = new AnvilSplitWindowImpl(viewer, this.title, (AbstractGui)this.upperGuiSupplier.get(), (AbstractGui)this.lowerGuiSupplier.get(), this.renameHandlers, this.closeable);
            this.applyModifiers(window);
            return window;
        }
    }
}

