/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.libs.invui.window;

import com.thexfactor117.levels.bukkit.libs.invui.InvUI;
import com.thexfactor117.levels.bukkit.libs.invui.window.AbstractDoubleWindow;
import com.thexfactor117.levels.bukkit.libs.invui.window.AbstractWindow;
import com.thexfactor117.levels.bukkit.libs.invui.window.Window;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityPickupItemEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.event.inventory.InventoryDragEvent;
import org.bukkit.event.inventory.InventoryOpenEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.Inventory;
import org.jetbrains.annotations.Nullable;

public class WindowManager
implements Listener {
    private static WindowManager instance;
    private final Map<Inventory, AbstractWindow> windowsByInventory = new HashMap<Inventory, AbstractWindow>();
    private final Map<Player, AbstractWindow> windowsByPlayer = new HashMap<Player, AbstractWindow>();

    private WindowManager() {
        Bukkit.getPluginManager().registerEvents((Listener)this, InvUI.getInstance().getPlugin());
        InvUI.getInstance().addDisableHandler(() -> new HashSet<AbstractWindow>(this.windowsByPlayer.values()).forEach(AbstractWindow::close));
    }

    public static WindowManager getInstance() {
        return instance == null ? (instance = new WindowManager()) : instance;
    }

    public void addWindow(AbstractWindow window) {
        this.windowsByInventory.put(window.getInventories()[0], window);
        this.windowsByPlayer.put(window.getViewer(), window);
    }

    public void removeWindow(AbstractWindow window) {
        this.windowsByInventory.remove(window.getInventories()[0]);
        this.windowsByPlayer.remove(window.getViewer());
    }

    @Nullable
    public Window getWindow(Inventory inventory) {
        return this.windowsByInventory.get(inventory);
    }

    @Nullable
    public Window getOpenWindow(Player player) {
        return this.windowsByPlayer.get(player);
    }

    public Set<Window> getWindows() {
        return new HashSet<Window>(this.windowsByInventory.values());
    }

    @Deprecated
    public Set<Window> getOpenWindows() {
        return this.getWindows();
    }

    @EventHandler
    private void handleInventoryClick(InventoryClickEvent event) {
        AbstractWindow window = (AbstractWindow)this.getOpenWindow((Player)event.getWhoClicked());
        if (window != null) {
            window.handleClickEvent(event);
            if (event.getClick().name().equals("SWAP_OFFHAND") && event.isCancelled()) {
                EntityEquipment equipment = event.getWhoClicked().getEquipment();
                equipment.setItemInOffHand(equipment.getItemInOffHand());
            }
        }
    }

    @EventHandler
    private void handleInventoryDrag(InventoryDragEvent event) {
        AbstractWindow window = (AbstractWindow)this.getOpenWindow((Player)event.getWhoClicked());
        if (window != null) {
            window.handleDragEvent(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST)
    private void handleInventoryClose(InventoryCloseEvent event) {
        Player player = (Player)event.getPlayer();
        AbstractWindow window = (AbstractWindow)this.getWindow(event.getInventory());
        if (window != null) {
            window.handleCloseEvent(false);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void handleInventoryOpen(InventoryOpenEvent event) {
        AbstractWindow window = (AbstractWindow)this.getWindow(event.getInventory());
        if (window != null) {
            window.handleOpenEvent(event);
        }
    }

    @EventHandler
    private void handlePlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        AbstractWindow window = (AbstractWindow)this.getOpenWindow(player);
        if (window != null) {
            window.handleCloseEvent(true);
        }
    }

    @EventHandler
    private void handlePlayerDeath(PlayerDeathEvent event) {
        Player player = event.getEntity();
        AbstractWindow window = (AbstractWindow)this.getOpenWindow(player);
        if (window != null) {
            window.handleViewerDeath(event);
        }
    }

    @EventHandler(priority=EventPriority.HIGHEST, ignoreCancelled=true)
    private void handleItemPickup(EntityPickupItemEvent event) {
        Window window;
        LivingEntity entity = event.getEntity();
        if (entity instanceof Player && (window = this.getOpenWindow((Player)entity)) instanceof AbstractDoubleWindow) {
            event.setCancelled(true);
        }
    }
}

