/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.util;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;
import org.bukkit.inventory.meta.ItemMeta;

public class StackUtil {
    private static final MethodHandle ItemStack$getItemName;
    private static final MethodHandle ItemStack$hasItemName;
    private static final boolean hasItemName;

    public static void safeRepair(ItemMeta meta, int repairDurability) {
        if (!(meta instanceof Damageable)) {
            return;
        }
        Damageable dmg = (Damageable)meta;
        dmg.setDamage(Math.max(dmg.getDamage() - repairDurability, 0));
    }

    public static String getName(ItemStack item) {
        String displayName;
        block7: {
            ItemMeta meta = item.getItemMeta();
            if (meta.hasDisplayName() && meta.getDisplayName() != null) {
                displayName = meta.getDisplayName();
            } else if (hasItemName) {
                try {
                    if (ItemStack$hasItemName.invoke(item)) {
                        displayName = ItemStack$getItemName.invoke(item).toString();
                        break block7;
                    }
                    displayName = StackUtil.processDisplayName(item, meta);
                }
                catch (Throwable ignored) {
                    displayName = StackUtil.processDisplayName(item, meta);
                }
            } else {
                displayName = StackUtil.processDisplayName(item, meta);
            }
        }
        return displayName;
    }

    private static String processDisplayName(ItemStack item, ItemMeta meta) {
        String displayName = !meta.hasDisplayName() ? StackUtil.getFriendlyName(item) : "";
        return displayName;
    }

    private static String getFriendlyName(ItemStack itemStack) {
        if (itemStack == null || itemStack.getType() == Material.AIR) {
            return "Air";
        }
        if (itemStack.hasItemMeta() && itemStack.getItemMeta().hasDisplayName()) {
            return itemStack.getItemMeta().getDisplayName();
        }
        return StackUtil.capitalizeFully(itemStack.getType().name().toLowerCase());
    }

    private static String capitalizeFully(String name) {
        if (name == null) {
            return "";
        }
        if (name.length() <= 1) {
            return name.toUpperCase();
        }
        if (!name.contains("_")) {
            return name.substring(0, 1).toUpperCase() + name.substring(1).toLowerCase();
        }
        StringBuilder sbName = new StringBuilder();
        for (String subName : name.split("_")) {
            sbName.append(subName.substring(0, 1).toUpperCase() + subName.substring(1).toLowerCase()).append(" ");
        }
        return sbName.substring(0, sbName.length() - 1);
    }

    static {
        MethodHandle itemStack$hasItemName1;
        MethodHandle itemStack$getItemName1;
        MethodHandles.Lookup lookup = MethodHandles.lookup();
        try {
            itemStack$getItemName1 = lookup.findVirtual(ItemStack.class, "getItemName", MethodType.methodType(String.class));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            itemStack$getItemName1 = null;
        }
        ItemStack$getItemName = itemStack$getItemName1;
        try {
            itemStack$hasItemName1 = lookup.findVirtual(ItemStack.class, "hasItemName", MethodType.methodType(Boolean.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            itemStack$hasItemName1 = null;
        }
        ItemStack$hasItemName = itemStack$hasItemName1;
        hasItemName = ItemStack$hasItemName != null && ItemStack$getItemName != null;
    }
}

