/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.util;

import com.google.common.collect.Multimap;
import com.thexfactor117.levels.bukkit.leveling.Experience;
import com.thexfactor117.levels.bukkit.libs.xseries.XAttribute;
import com.thexfactor117.levels.bukkit.nbt.NBTHelper;
import com.thexfactor117.levels.bukkit.nbt.NBTImpl;
import com.thexfactor117.levels.bukkit.util.ItemUtil;
import com.thexfactor117.levels.common.config.Configs;
import com.thexfactor117.levels.common.leveling.MinecraftAttributes;
import com.thexfactor117.levels.common.leveling.Rarity;
import java.util.Collection;
import java.util.Random;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Sound;
import org.bukkit.attribute.Attribute;
import org.bukkit.attribute.AttributeModifier;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class WeaponHelper {
    public static final NamespacedKey MULTIPLIER = new NamespacedKey("levels", "multiplier");
    private static final Random RANDOM = new Random();

    public static void create(ItemStack stack, Player player) {
        if (stack == null || stack.getItemMeta() == null || stack.getType().isAir()) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        PersistentDataContainer pdc = meta.getPersistentDataContainer();
        NBTImpl nbt = NBTHelper.toCommon(pdc);
        Rarity rarity = Rarity.getRarity(nbt);
        if (rarity != Rarity.DEFAULT) {
            return;
        }
        Rarity rarityNew = Rarity.getRandomRarity(RANDOM);
        rarityNew.setRarity(nbt);
        if (rarityNew == Rarity.MYTHIC) {
            player.playSound((Entity)player, Sound.ENTITY_ENDER_DRAGON_DEATH, 1.0f, 1.0f);
        }
        if (Configs.getInstance().main.getBoolean("unlimitedDurability")) {
            meta.setUnbreakable(true);
        }
        Experience exp = new Experience(stack, meta);
        exp.setLevel(1);
        pdc.set(MULTIPLIER, PersistentDataType.DOUBLE, (Object)rarityNew.generateWeightedMultiplier());
        meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_UNBREAKABLE});
        WeaponHelper.setAttributeModifiers(meta, stack);
        stack.setItemMeta(meta);
    }

    private static void setAttributeModifiers(ItemMeta meta, ItemStack stack) {
        EquipmentSlot slot;
        NBTImpl inbt = NBTHelper.toCommon(meta.getPersistentDataContainer());
        Rarity rarity = Rarity.getRarity(inbt);
        Material type = stack.getType();
        boolean isWeapon = ItemUtil.isWeapon(type);
        if (isWeapon) {
            Multimap map = type.getDefaultAttributeModifiers(EquipmentSlot.HAND);
            Collection damageCollection = map.get((Object)((Attribute)XAttribute.ATTACK_DAMAGE.get()));
            Collection speedCollection = map.get((Object)((Attribute)XAttribute.ATTACK_SPEED.get()));
            AttributeModifier damageModifier = (AttributeModifier)damageCollection.toArray()[0];
            AttributeModifier speedModifier = (AttributeModifier)speedCollection.toArray()[0];
            double baseDamage = damageModifier.getAmount() + 1.0;
            double baseSpeed = speedModifier.getAmount();
            double damage = rarity.generateWeightedDamage(baseDamage);
            double speed = rarity.generateWeightedAttackSpeed(baseSpeed);
            AttributeModifier attackDamage = new AttributeModifier(MinecraftAttributes.ATTACK_DAMAGE_UUID, "attackDamage", damage, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND);
            AttributeModifier attackSpeed = new AttributeModifier(MinecraftAttributes.ATTACK_SPEED_UUID, "attackSpeed", speed, AttributeModifier.Operation.ADD_NUMBER, EquipmentSlot.HAND);
            meta.addAttributeModifier((Attribute)XAttribute.ATTACK_DAMAGE.get(), attackDamage);
            meta.addAttributeModifier((Attribute)XAttribute.ATTACK_SPEED.get(), attackSpeed);
        }
        if ((slot = WeaponHelper.getSlotOfArmor(type)) != null) {
            WeaponHelper.applyArmorAttributeChange(meta, rarity, type, slot);
        }
    }

    public static EquipmentSlot getSlotOfArmor(Material type) {
        if (ItemUtil.isHelmet(type)) {
            return EquipmentSlot.HEAD;
        }
        if (ItemUtil.isChestplate(type)) {
            return EquipmentSlot.CHEST;
        }
        if (ItemUtil.isLeggings(type)) {
            return EquipmentSlot.LEGS;
        }
        if (ItemUtil.isBoots(type)) {
            return EquipmentSlot.FEET;
        }
        return null;
    }

    private static void applyArmorAttributeChange(ItemMeta meta, Rarity rarity, Material type, EquipmentSlot slot) {
        Multimap map = type.getDefaultAttributeModifiers(slot);
        Collection armorCollection = map.get((Object)((Attribute)XAttribute.ARMOR.get()));
        Collection toughnessCollection = map.get((Object)((Attribute)XAttribute.ARMOR_TOUGHNESS.get()));
        AttributeModifier armorModifier = (AttributeModifier)armorCollection.toArray()[0];
        AttributeModifier toughnessModifier = (AttributeModifier)toughnessCollection.toArray()[0];
        double baseArmor = armorModifier.getAmount();
        double baseToughness = toughnessModifier.getAmount();
        double newArmor = rarity.getWeightedArmor(baseArmor);
        double newToughness = rarity.generateWeightedArmorToughness(baseToughness);
        AttributeModifier armor = new AttributeModifier(MinecraftAttributes.ARMOR_UUID, "armor", newArmor, AttributeModifier.Operation.ADD_NUMBER, slot);
        AttributeModifier toughness = new AttributeModifier(MinecraftAttributes.ARMOR_TOUGHNESS_UUID, "armorToughness", newToughness, AttributeModifier.Operation.ADD_NUMBER, slot);
        meta.addAttributeModifier((Attribute)XAttribute.ARMOR.get(), armor);
        meta.addAttributeModifier((Attribute)XAttribute.ARMOR_TOUGHNESS.get(), toughness);
    }
}

