/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.ux.gui;

import com.thexfactor117.levels.bukkit.leveling.Experience;
import com.thexfactor117.levels.bukkit.libs.invui.item.Click;
import com.thexfactor117.levels.bukkit.libs.invui.item.ItemProvider;
import com.thexfactor117.levels.bukkit.libs.invui.item.builder.ItemBuilder;
import com.thexfactor117.levels.bukkit.libs.invui.item.impl.SimpleItem;
import com.thexfactor117.levels.bukkit.nbt.NBTHelper;
import com.thexfactor117.levels.bukkit.nbt.NBTImpl;
import com.thexfactor117.levels.common.leveling.attributes.AnyAttributes;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeBase;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeRarity;
import com.thexfactor117.levels.common.leveling.attributes.components.config.LevelConfigAttribute;
import com.thexfactor117.levels.common.nbt.INBT;
import com.thexfactor117.levels.common.resources.Localization;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class AttributeItem
extends SimpleItem {
    public AttributeItem(ItemStack main, AttributeBase attributeBase) {
        super(AttributeItem.getProvider(main, attributeBase), AttributeItem.consumer(main, attributeBase));
    }

    public static ItemProvider getProvider(ItemStack main, AttributeBase attributeBase) {
        Material material = switch (attributeBase.getRarity()) {
            default -> throw new MatchException(null, null);
            case AttributeRarity.UNCOMMON -> Material.GREEN_WOOL;
            case AttributeRarity.RARE -> Material.BLUE_WOOL;
            case AttributeRarity.LEGENDARY -> Material.YELLOW_WOOL;
        };
        int maxLevel = LevelConfigAttribute.getMaxLevel(attributeBase);
        NBTImpl nbt = NBTHelper.toCommon(main.getItemMeta().getPersistentDataContainer());
        int tier = attributeBase.getAttributeTier(nbt);
        Object display = tier == maxLevel ? attributeBase.getBaseName() + " MAX" : attributeBase.getCompleteName(tier + 1);
        return (ItemProvider)((ItemBuilder)new ItemBuilder(material).setDisplayName((String)display)).setLegacyLore(attributeBase.getUpgradeSummary(nbt, Localization.getLocalization()));
    }

    private static Consumer<Click> consumer(ItemStack stack, AttributeBase attribute) {
        return click -> {
            boolean shouldUpgrade;
            Experience exp = new Experience(stack);
            int tokens = exp.getAttributeTokens();
            if (tokens <= 0) {
                return;
            }
            INBT nbt = exp.getNBT();
            int currentLevel = attribute.getAttributeTier(nbt);
            boolean hasAttribute = attribute.hasAttribute(nbt);
            boolean isMaxLevel = currentLevel >= LevelConfigAttribute.getMaxLevel(attribute);
            int cost = attribute.getRarity().getCost();
            if (isMaxLevel) {
                shouldUpgrade = false;
            } else if (hasAttribute) {
                cost = 1;
                shouldUpgrade = true;
            } else {
                boolean bl = shouldUpgrade = tokens >= cost;
            }
            if (!shouldUpgrade) {
                return;
            }
            int newTier = currentLevel + 1;
            attribute.setAttributeTier(nbt, newTier);
            exp.addAttributeTokens(-cost);
            ItemMeta meta = exp.getMeta();
            if (!attribute.hasAttribute(nbt) && AnyAttributes.UNBREAKABLE.equals(attribute)) {
                meta.setUnbreakable(true);
            }
            stack.setItemMeta(meta);
        };
    }
}

