/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.bukkit.ux.gui;

import com.thexfactor117.levels.bukkit.leveling.Experience;
import com.thexfactor117.levels.bukkit.libs.invui.gui.Gui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.PagedGui;
import com.thexfactor117.levels.bukkit.libs.invui.gui.structure.Markers;
import com.thexfactor117.levels.bukkit.libs.invui.item.Click;
import com.thexfactor117.levels.bukkit.libs.invui.item.Item;
import com.thexfactor117.levels.bukkit.libs.invui.item.ItemProvider;
import com.thexfactor117.levels.bukkit.libs.invui.item.builder.ItemBuilder;
import com.thexfactor117.levels.bukkit.libs.invui.item.impl.SimpleItem;
import com.thexfactor117.levels.bukkit.nbt.NBTHelper;
import com.thexfactor117.levels.bukkit.util.WeaponHelper;
import com.thexfactor117.levels.bukkit.ux.gui.AttributeItem;
import com.thexfactor117.levels.bukkit.ux.gui.BackItem;
import com.thexfactor117.levels.bukkit.ux.gui.NextItem;
import com.thexfactor117.levels.common.color.LegacyTextColor;
import com.thexfactor117.levels.common.leveling.ItemType;
import com.thexfactor117.levels.common.leveling.Rarity;
import com.thexfactor117.levels.common.leveling.attributes.components.AttributeBase;
import com.thexfactor117.levels.common.resources.Localization;
import java.util.ArrayList;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;

public class LevelsGui {
    private static final PagedGui.Builder<Item> dietMenuPrefab;
    private static final Consumer<Click> useless;
    private static final SimpleItem background;
    private static final SimpleItem anotherBackground;

    public static Gui get(ItemStack stack, ItemType type) {
        PagedGui.Builder prepared = (PagedGui.Builder)((PagedGui.Builder)dietMenuPrefab.clone()).addIngredient('I', new SimpleItem(stack));
        Localization loc = Localization.getLocalization();
        Experience exp = new Experience(stack);
        ArrayList<String> expDesc = new ArrayList<String>();
        expDesc.add("");
        double multiplier = (Double)exp.getPdc().get(WeaponHelper.MULTIPLIER, PersistentDataType.DOUBLE);
        expDesc.add(String.valueOf((Object)LegacyTextColor.GRAY) + "Levelup Multiplier: " + multiplier);
        expDesc.addAll(exp.displayExp(Localization.getLocalization()));
        Rarity rarity = Rarity.getRarity(exp.getNBT());
        expDesc.add(String.valueOf((Object)LegacyTextColor.GRAY) + loc.format("levels.misc.rarity", new String[0]) + ": " + rarity.getColor() + String.valueOf((Object)rarity));
        expDesc.add("");
        SimpleItem xpViewer = new SimpleItem((ItemProvider)((ItemBuilder)new ItemBuilder(Material.EXPERIENCE_BOTTLE).setDisplayName("Level Info")).setLegacyLore(expDesc), useless);
        prepared.addIngredient('E', xpViewer);
        ArrayList<String> attributeDesc = new ArrayList<String>();
        attributeDesc.add("");
        attributeDesc.add(loc.format("levels.misc.attributes.tokens", new String[0]) + ": " + exp.getAttributeTokens());
        attributeDesc.add("");
        attributeDesc.addAll(type.displayAttributes(NBTHelper.toCommon(stack.getItemMeta().getPersistentDataContainer())));
        SimpleItem attributeViewer = new SimpleItem((ItemProvider)((ItemBuilder)new ItemBuilder(Material.NETHER_STAR).setDisplayName("Attribute Info")).setLegacyLore(attributeDesc), useless);
        prepared.addIngredient('A', attributeViewer);
        ArrayList<AttributeItem> attributes = new ArrayList<AttributeItem>();
        for (AttributeBase base : type.enabledAttributes()) {
            attributes.add(new AttributeItem(stack, base));
        }
        prepared.setContent(attributes);
        return prepared.build();
    }

    static {
        useless = click -> click.getEvent().setCancelled(true);
        background = new SimpleItem(new ItemBuilder(Material.BLACK_STAINED_GLASS_PANE), useless);
        anotherBackground = new SimpleItem(new ItemBuilder(Material.GRAY_STAINED_GLASS_PANE), useless);
        dietMenuPrefab = ((PagedGui.Builder)((PagedGui.Builder)((PagedGui.Builder)((PagedGui.Builder)((PagedGui.Builder)((PagedGui.Builder)PagedGui.items().setStructure("# # # # # # # # #", "# E # w I w # A #", "# # # # # # # # #", "# x x x x x x x #", "# x x x x x x x #", "# # < # # # > # #")).addIngredient('#', background)).addIngredient('w', anotherBackground)).addIngredient('x', Markers.CONTENT_LIST_SLOT_HORIZONTAL)).addIngredient('<', new BackItem())).addIngredient('>', new NextItem())).setContent(new ArrayList()).setPageChangeHandlers(new ArrayList<BiConsumer<Integer, Integer>>());
    }
}

