/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.common.collections;

import java.util.NavigableMap;
import java.util.Random;
import java.util.TreeMap;

public class RandomCollection<E> {
    private final NavigableMap<Double, E> map = new TreeMap<Double, E>();
    private double total = 0.0;

    public void add(double weight, E result) {
        if (weight <= 0.0) {
            return;
        }
        this.total += weight;
        this.map.put(this.total, result);
    }

    public E next(Random random) {
        if (this.total == 0.0) {
            throw new RuntimeException("Empty random");
        }
        double value = random.nextDouble() * this.total;
        return this.map.ceilingEntry(value).getValue();
    }
}

