/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.common.config;

import com.thexfactor117.levels.common.config.ConfigEntryHolder;
import com.thexfactor117.levels.common.config.ConfigMap;
import com.thexfactor117.levels.common.utils.FieldProcessor;
import com.thexfactor117.levels.common.utils.PropertiesUtil;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import lombok.Generated;

public class ConfigManager
implements ConfigMap {
    private final File file;
    private Map<String, String> map = new HashMap<String, String>();

    public ConfigManager(File file) {
        this.file = file;
    }

    @SafeVarargs
    public final <T extends ConfigEntryHolder> ConfigManager process(T ... args) {
        for (T arg : args) {
            this.map.putAll(arg.getEntry().getMap());
        }
        return this;
    }

    public final <T extends ConfigEntryHolder> ConfigManager process(Collection<T> args) {
        for (ConfigEntryHolder arg : args) {
            this.map.putAll(arg.getEntry().getMap());
        }
        return this;
    }

    public final <T> ConfigManager processClazz(Class<T> clazz) {
        this.process((Collection<T>)FieldProcessor.getFields(ConfigEntryHolder.class, clazz));
        return this;
    }

    public void initFile() {
        this.file.getParentFile().mkdirs();
        try {
            this.file.createNewFile();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        boolean modified = false;
        Map<String, String> available = PropertiesUtil.loadFile(this.file);
        for (Map.Entry<String, String> single : this.map.entrySet()) {
            if (available.containsKey(single.getKey())) continue;
            available.put(single.getKey(), single.getValue());
            modified = true;
        }
        if (modified) {
            PropertiesUtil.saveFile(available, this.file);
        }
        this.map = available;
    }

    public void save() {
        PropertiesUtil.saveFile(this.map, this.file);
    }

    public void reload() {
        this.map = PropertiesUtil.loadFile(this.file);
    }

    @Generated
    public File getFile() {
        return this.file;
    }

    @Override
    @Generated
    public Map<String, String> getMap() {
        return this.map;
    }
}

