/*
 * Decompiled with CFR 0.152.
 */
package com.thexfactor117.levels.common.utils;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class FieldProcessor {
    private static final ConcurrentHashMap<Class<? extends Enum<?>>, MethodHandle> enumCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<Class<?>, Map<String, MethodHandle>> cache = new ConcurrentHashMap();
    private static final MethodHandles.Lookup lookup = MethodHandles.lookup();

    private static <T extends Enum<?>> T[] getValues(Class<T> clazz) {
        try {
            MethodHandle handle = enumCache.computeIfAbsent(clazz, key -> {
                try {
                    Class<?> arrayClazz = Array.newInstance(key, 0).getClass();
                    return lookup.findStatic((Class<?>)key, "values", MethodType.methodType(arrayClazz));
                }
                catch (IllegalAccessException | NoSuchMethodException e) {
                    throw new RuntimeException("Unable to find 'values' method for enum class: " + key.getName(), e);
                }
            });
            return handle.invoke();
        }
        catch (Throwable t) {
            throw new RuntimeException("Failed to invoke 'values' method on enum class: " + clazz.getName(), t);
        }
    }

    public static <T> List<T> getFields(Class<T> wanted, Class<?> clazz) {
        ArrayList<T> list = new ArrayList<T>();
        if (clazz.isEnum()) {
            Class<?> enumClass = clazz;
            for (Enum constant : FieldProcessor.getValues(enumClass)) {
                if (!wanted.isInstance(constant)) continue;
                list.add(wanted.cast(constant));
            }
            return list;
        }
        Map methodCache = cache.computeIfAbsent(clazz, key -> {
            HashMap<String, MethodHandle> newMap = new HashMap<String, MethodHandle>();
            for (Field field : clazz.getDeclaredFields()) {
                int modifiers = field.getModifiers();
                if (!Modifier.isStatic(modifiers)) continue;
                String name = field.getName();
                newMap.computeIfAbsent(name, key2 -> {
                    try {
                        return lookup.findStaticGetter(clazz, name, field.getType());
                    }
                    catch (IllegalAccessException | NoSuchFieldException e) {
                        throw new RuntimeException(e);
                    }
                });
            }
            return newMap;
        });
        for (MethodHandle handle : methodCache.values()) {
            try {
                Object value = handle.invoke();
                if (!wanted.isInstance(value)) continue;
                list.add(wanted.cast(value));
            }
            catch (Throwable throwable) {}
        }
        return list;
    }

    public static <T> List<T> getFields(Class<T> wanted, Class<?> ... clazz) {
        ArrayList<T> list = new ArrayList<T>();
        for (Class<?> clazzLoop : clazz) {
            list.addAll(FieldProcessor.getFields(wanted, clazzLoop));
        }
        return list;
    }
}

