/*
 * Decompiled with CFR 0.152.
 */
package me.jungdab.zsm.entity;

import java.util.List;
import me.jungdab.zsm.client.camera.CameraShake;
import me.jungdab.zsm.entity.BossZombiePart;
import me.jungdab.zsm.entity.TurretEntity;
import me.jungdab.zsm.entity.ZSMBasicEntity;
import me.jungdab.zsm.entity.ai.goal.GlobalTargetGoal;
import me.jungdab.zsm.registry.ModAdvancements;
import me.jungdab.zsm.registry.ModEffects;
import me.jungdab.zsm.registry.ModEntities;
import me.jungdab.zsm.registry.ModSounds;
import net.minecraft.class_1259;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3213;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.constant.DefaultAnimations;
import software.bernie.geckolib.util.GeckoLibUtil;

public class BossZombieEntity
extends ZSMBasicEntity
implements GeoEntity {
    private final AnimatableInstanceCache geoCache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private final BossZombiePart part;
    private final class_3213 bossBar = new class_3213(this.method_5476(), class_1259.class_1260.field_5785, class_1259.class_1261.field_5795);
    public int spawnTime;
    public boolean isSpawning = true;
    private static final class_2940<Integer> ANIMATION_ID = class_2945.method_12791(BossZombieEntity.class, (class_2941)class_2943.field_13327);

    public BossZombieEntity(class_1299<? extends class_1588> entityType, class_1937 world) {
        super(entityType, world);
        this.part = new BossZombiePart(ModEntities.BOSS_ZOMBIE_PART, world);
        this.part.setOwner(this);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(ANIMATION_ID, (Object)5);
    }

    public void setAnimationId(int id) {
        this.field_6011.method_12778(ANIMATION_ID, (Object)id);
    }

    public int getAnimationId() {
        return (Integer)this.field_6011.method_12789(ANIMATION_ID);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569("spawnTime", this.spawnTime);
        nbt.method_10569("AnimationId", this.getAnimationId());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_10545("AnimationId")) {
            this.setAnimationId(nbt.method_10550("AnimationId"));
        }
        if (nbt.method_10545("spawnTime")) {
            this.spawnTime = nbt.method_10550("spawnTime");
        }
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(2, (class_1352)new BossZombiePatternGoal(this));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6185.method_6277(1, new GlobalTargetGoal<TurretEntity>((class_1308)this, TurretEntity.class, 1));
    }

    public void attack(class_1309 target) {
        this.method_5783(ModSounds.ENTITY_BOSS_ZOMBIE_SWING, 5.0f, 1.0f);
        class_1937 world = this.method_37908();
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        class_1282 source = this.method_48923().method_48812((class_1309)this);
        float f = (float)this.method_45325(class_5134.field_23721);
        target.method_64397(serverWorld, source, f);
    }

    public void smash() {
        this.method_5783(class_3417.field_49924, 5.0f, 0.1f);
        this.method_5783((class_3414)class_3417.field_15152.comp_349(), 5.0f, 0.5f);
        class_1937 world = this.method_37908();
        if (!(world instanceof class_3218)) {
            return;
        }
        class_3218 serverWorld = (class_3218)world;
        List targetList = this.method_37908().method_8390(class_1309.class, new class_238(this.method_23317() - 30.0, this.method_23318() - 4.0, this.method_23321() - 30.0, this.method_23317() + 30.0, this.method_23318() + 4.0, this.method_23321() + 30.0), entity -> !entity.equals((Object)this));
        if (targetList.isEmpty()) {
            return;
        }
        float f = (float)this.method_45325(class_5134.field_23721) * 1.5f;
        class_1282 damageSource = this.method_48923().method_48812((class_1309)this);
        for (class_1309 entity2 : targetList) {
            entity2.method_64397(serverWorld, damageSource, f);
            if (!entity2.method_24828()) continue;
            entity2.method_6092(new class_1293(ModEffects.STUN, 60, 0));
        }
    }

    public void jump(class_1309 target) {
        class_243 monsterLocation = this.method_19538();
        class_243 targetLocation = target.method_19538();
        class_243 direction = targetLocation.method_1020(monsterLocation);
        double distance = new class_243(monsterLocation.method_10216(), 0.0, monsterLocation.method_10215()).method_1022(new class_243(targetLocation.method_10216(), 0.0, targetLocation.method_10215()));
        class_243 horizontalDirection = new class_243(direction.method_10216(), 0.0, direction.method_10215()).method_1029();
        double speedMultiplier = distance / 5.0;
        class_243 horizontalVelocity = horizontalDirection.method_1021(speedMultiplier);
        double heightDifference = targetLocation.method_10214() - monsterLocation.method_10214();
        double verticalSpeed = 0.5;
        class_243 velocity = new class_243(horizontalVelocity.method_10216(), verticalSpeed += Math.max(0.0, heightDifference / 10.0), horizontalVelocity.method_10215());
        this.method_18799(velocity);
    }

    public void method_5982() {
    }

    public void method_5650(class_1297.class_5529 reason) {
        class_3218 world;
        List players;
        if (this.part != null) {
            this.part.method_5650(reason);
        }
        if (!this.method_37908().field_9236 && (players = (world = (class_3218)this.method_37908()).method_18456()) != null && !players.isEmpty()) {
            for (class_3222 player : players) {
                player.method_14236().method_12878(ModAdvancements.DEFEAT_BOSS, "defeat_boss");
            }
        }
        super.method_5650(reason);
    }

    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236 && this.isSpawning) {
            ++this.spawnTime;
            if (this.spawnTime > 80) {
                this.setAnimationId(0);
                this.isSpawning = false;
            }
        }
    }

    protected void method_5958(class_3218 world) {
        this.bossBar.method_5408(this.method_6032() / this.method_6063());
        super.method_5958(world);
    }

    public void method_6007() {
        super.method_6007();
        this.movePart();
    }

    private void movePart() {
        this.part.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
        if (!this.method_37908().field_9236) {
            class_238 box = this.part.method_5829();
            box.method_1014(0.2);
            for (class_2338 blockPos : class_2338.method_10094((int)class_3532.method_15357((double)box.field_1323), (int)class_3532.method_15357((double)(box.field_1322 + 1.5)), (int)class_3532.method_15357((double)box.field_1321), (int)class_3532.method_15357((double)box.field_1320), (int)class_3532.method_15357((double)box.field_1325), (int)class_3532.method_15357((double)box.field_1324))) {
                this.method_37908().method_8651(blockPos, false, (class_1297)this);
            }
        }
    }

    public void method_5837(class_3222 player) {
        super.method_5837(player);
        this.bossBar.method_14088(player);
    }

    public void method_5742(class_3222 player) {
        super.method_5742(player);
        this.bossBar.method_14089(player);
    }

    public static class_5132.class_5133 createZombieAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 1000.0).method_26868(class_5134.field_23719, 0.35).method_26868(class_5134.field_51578, 1.0).method_26868(class_5134.field_23721, 10.0).method_26868(class_5134.field_47761, 1.0).method_26868(class_5134.field_23718, 1.0);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllers) {
        controllers.add(new AnimationController[]{BossZombieEntity.animationController(this).setCustomInstructionKeyframeHandler(event -> {
            String command;
            switch (command = event.getKeyframeData().getInstructions()) {
                case "sShake;": {
                    CameraShake.startShake(0.1f);
                    break;
                }
                case "mShake;": {
                    CameraShake.startShake(0.5f);
                    break;
                }
                case "lShake;": {
                    CameraShake.startShake(1.0f);
                }
            }
        }), DefaultAnimations.genericDeathController((class_1309)this)});
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.geoCache;
    }

    public static AnimationController<BossZombieEntity> animationController(BossZombieEntity animatable) {
        return new AnimationController((GeoAnimatable)animatable, "Animation", 5, state -> {
            switch (animatable.getAnimationId()) {
                case 0: {
                    return state.setAndContinue(state.isMoving() ? DefaultAnimations.WALK : DefaultAnimations.IDLE);
                }
                case 1: {
                    return state.setAndContinue(RawAnimation.begin().thenPlay("attack.1"));
                }
                case 2: {
                    return state.setAndContinue(RawAnimation.begin().thenPlay("attack.2"));
                }
                case 3: {
                    return state.setAndContinue(RawAnimation.begin().thenPlay("behavior.jump"));
                }
                case 5: {
                    return state.setAndContinue(RawAnimation.begin().thenPlay("misc.spawn"));
                }
            }
            return PlayState.STOP;
        });
    }

    class BossZombiePatternGoal
    extends class_1352 {
        private final BossZombieEntity mob;
        private int pattern = 0;
        private int progressTick = 0;
        private int smashCooldown = 0;

        BossZombiePatternGoal(BossZombieEntity this$0) {
            this.mob = this$0;
        }

        public boolean method_6264() {
            if (this.mob.isSpawning) {
                return false;
            }
            class_1309 target = this.mob.method_5968();
            if (target == null) {
                return false;
            }
            return target.method_5805();
        }

        public boolean method_6266() {
            if (this.pattern != 0) {
                return true;
            }
            class_1309 target = this.mob.method_5968();
            if (target == null) {
                return false;
            }
            return target.method_5805();
        }

        public void method_6268() {
            class_1309 target = this.mob.method_5968();
            if (this.pattern == 0) {
                double distance = this.mob.method_5858((class_1297)target);
                if (distance < 49.0) {
                    this.mob.method_5942().method_6340();
                    this.pattern = this.smashCooldown > 0 ? 2 : 1;
                    this.progressTick = 0;
                } else if (distance > 400.0) {
                    this.mob.method_5942().method_6340();
                    this.pattern = 3;
                    this.progressTick = 0;
                }
            }
            switch (this.pattern) {
                case 0: {
                    if (target == null) break;
                    this.mob.method_5942().method_6335((class_1297)target, 1.0);
                    break;
                }
                case 1: {
                    this.attack1();
                    break;
                }
                case 2: {
                    this.attack2();
                    break;
                }
                case 3: {
                    this.jump();
                }
            }
            if (this.smashCooldown > 0) {
                --this.smashCooldown;
            }
        }

        private void attack1() {
            if (this.progressTick == 0) {
                this.mob.setAnimationId(1);
            }
            if (this.progressTick == 30) {
                this.mob.smash();
            }
            if (this.progressTick == 40) {
                this.mob.setAnimationId(0);
            }
            if (this.progressTick == 41) {
                this.pattern = 0;
                this.smashCooldown = 200;
            }
            ++this.progressTick;
        }

        private void attack2() {
            class_1309 target = this.mob.method_5968();
            if (this.progressTick == 0) {
                this.mob.setAnimationId(2);
            }
            if (this.progressTick == 7 && target != null) {
                this.mob.attack(target);
            }
            if (this.progressTick == 13) {
                this.mob.setAnimationId(0);
            }
            if (this.progressTick == 13) {
                this.pattern = 0;
            }
            if (target != null) {
                this.mob.method_5702(class_2183.class_2184.field_9851, target.method_19538());
            }
            ++this.progressTick;
        }

        private void jump() {
            class_1309 target = this.mob.method_5968();
            if (this.progressTick == 0) {
                this.mob.setAnimationId(3);
            }
            if (this.progressTick == 13 && target != null) {
                this.mob.jump(target);
            }
            if (this.progressTick == 17) {
                this.mob.setAnimationId(0);
            }
            if (this.progressTick == 21) {
                this.pattern = 0;
            }
            if (target != null) {
                this.mob.method_5702(class_2183.class_2184.field_9851, target.method_19538());
            }
            ++this.progressTick;
        }
    }
}

