/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.TornadoEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class TornadoRenderer
extends EntityRenderer<TornadoEntity> {
    private static final ResourceLocation CORE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tornado", (String)"textures/entity/tornado/core.png");
    private static final RenderType CORE_RENDER_TYPE = RenderType.entityTranslucent((ResourceLocation)CORE_TEXTURE);
    private static final double[] TORNADO_HEIGHT = new double[]{25.0, 40.0, 60.0, 85.0, 120.0};
    private static final double[] MAX_RADIUS = new double[]{8.0, 12.0, 18.0, 26.0, 38.0};
    private static final double[] BASE_RADIUS = new double[]{2.0, 2.5, 3.0, 4.0, 5.0};

    public TornadoRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TornadoEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        int tier = entity.getTier();
        int tierIdx = Mth.clamp((int)(tier - 1), (int)0, (int)4);
        double height = TORNADO_HEIGHT[tierIdx];
        double maxRadius = MAX_RADIUS[tierIdx];
        double baseRadius = BASE_RADIUS[tierIdx];
        float time = (float)entity.tickCount + partialTicks;
        double leanAngle = (double)time * 0.004;
        double leanMagnitude = Math.sin((double)time * 0.008) * (5.0 + (double)tier * 2.0);
        double leanX = Math.cos(leanAngle) * leanMagnitude;
        double leanZ = Math.sin(leanAngle) * leanMagnitude;
        poseStack.pushPose();
        this.renderFunnel(poseStack, buffer.getBuffer(CORE_RENDER_TYPE), height, baseRadius, maxRadius, tier, time, leanX, leanZ, 1.0f, 0.85f, packedLight, 1.0f);
        poseStack.popPose();
    }

    private void renderFunnel(PoseStack poseStack, VertexConsumer consumer, double height, double baseRadius, double maxRadius, int tier, float time, double leanX, double leanZ, float radiusScale, float alpha, int packedLight, float rotationSpeed) {
        int segments = Math.max(20, (int)(height * 0.8));
        for (int i = 0; i < segments; ++i) {
            float yBottom = (float)((double)i * height / (double)segments);
            float yTop = (float)((double)(i + 1) * height / (double)segments);
            float progressBottom = yBottom / (float)height;
            float progressTop = yTop / (float)height;
            float radiusBottom = (float)(baseRadius * (double)radiusScale + (maxRadius * (double)radiusScale - baseRadius * (double)radiusScale) * Math.pow(progressBottom, 2.2));
            float radiusTop = (float)(baseRadius * (double)radiusScale + (maxRadius * (double)radiusScale - baseRadius * (double)radiusScale) * Math.pow(progressTop, 2.2));
            float bendFactorBottom = (float)Math.pow(progressBottom, 1.3);
            float bendFactorTop = (float)Math.pow(progressTop, 1.3);
            float wobbleScale = 0.08f + progressBottom * 0.15f;
            float wobbleXBottom = (float)(Math.sin((double)time * 0.025 * (double)rotationSpeed + (double)yBottom * 0.08) * (double)yBottom * (double)wobbleScale);
            float wobbleZBottom = (float)(Math.cos((double)time * 0.025 * (double)rotationSpeed + (double)yBottom * 0.08) * (double)yBottom * (double)wobbleScale);
            float wobbleXTop = (float)(Math.sin((double)time * 0.025 * (double)rotationSpeed + (double)yTop * 0.08) * (double)yTop * (double)wobbleScale);
            float wobbleZTop = (float)(Math.cos((double)time * 0.025 * (double)rotationSpeed + (double)yTop * 0.08) * (double)yTop * (double)wobbleScale);
            float xBottom = (float)(leanX * (double)bendFactorBottom + (double)wobbleXBottom);
            float zBottom = (float)(leanZ * (double)bendFactorBottom + (double)wobbleZBottom);
            float xTop = (float)(leanX * (double)bendFactorTop + (double)wobbleXTop);
            float zTop = (float)(leanZ * (double)bendFactorTop + (double)wobbleZTop);
            float segmentAlpha = alpha * (1.0f - progressBottom * 0.4f);
            Matrix4f pose = poseStack.last().pose();
            this.drawSegment(pose, consumer, xBottom, yBottom, zBottom, radiusBottom, xTop, yTop, zTop, radiusTop, time, packedLight, segmentAlpha, rotationSpeed);
        }
    }

    private void drawSegment(Matrix4f pose, VertexConsumer consumer, float x1, float y1, float z1, float r1, float x2, float y2, float z2, float r2, float time, int packedLight, float alpha, float rotationSpeed) {
        int slices = 24;
        float textureScroll = time * 0.03f * rotationSpeed;
        for (int i = 0; i < slices; ++i) {
            float angle1 = (float)((double)(i * 2) * Math.PI / (double)slices);
            float angle2 = (float)((double)((i + 1) * 2) * Math.PI / (double)slices);
            float sin1 = Mth.sin((float)angle1);
            float cos1 = Mth.cos((float)angle1);
            float sin2 = Mth.sin((float)angle2);
            float cos2 = Mth.cos((float)angle2);
            float bx1 = x1 + cos1 * r1;
            float bz1 = z1 + sin1 * r1;
            float bx2 = x1 + cos2 * r1;
            float bz2 = z1 + sin2 * r1;
            float tx1 = x2 + cos1 * r2;
            float tz1 = z2 + sin1 * r2;
            float tx2 = x2 + cos2 * r2;
            float tz2 = z2 + sin2 * r2;
            float u1 = (float)i / (float)slices + textureScroll;
            float u2 = (float)(i + 1) / (float)slices + textureScroll;
            float v1 = y1 / 60.0f;
            float v2 = y2 / 60.0f;
            int alphaInt = Mth.clamp((int)((int)(alpha * 255.0f)), (int)0, (int)255);
            int brightness = (int)(200.0f + 55.0f * (y1 / 100.0f));
            brightness = Mth.clamp((int)brightness, (int)180, (int)255);
            consumer.addVertex(pose, bx1, y1, bz1).setColor(brightness, brightness, brightness, alphaInt).setUv(u1, v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(cos1, 0.0f, sin1);
            consumer.addVertex(pose, bx2, y1, bz2).setColor(brightness, brightness, brightness, alphaInt).setUv(u2, v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(cos2, 0.0f, sin2);
            consumer.addVertex(pose, tx2, y2, tz2).setColor(brightness, brightness, brightness, alphaInt).setUv(u2, v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(cos2, 0.0f, sin2);
            consumer.addVertex(pose, tx1, y2, tz1).setColor(brightness, brightness, brightness, alphaInt).setUv(u1, v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(cos1, 0.0f, sin1);
        }
    }

    public boolean shouldRender(TornadoEntity livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public ResourceLocation getTextureLocation(TornadoEntity entity) {
        return CORE_TEXTURE;
    }
}

