/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.TornadoEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import org.joml.Matrix4f;

public class TornadoRenderer
extends EntityRenderer<TornadoEntity> {
    private static final ResourceLocation CORE_TEXTURE = ResourceLocation.fromNamespaceAndPath((String)"tornado", (String)"textures/entity/tornado/core.png");
    private static final RenderType CORE_RENDER_TYPE = RenderType.entityTranslucent((ResourceLocation)CORE_TEXTURE);

    public TornadoRenderer(EntityRendererProvider.Context context) {
        super(context);
    }

    public void render(TornadoEntity entity, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        if (entity.tickCount % 40 == 0) {
            System.out.println("DEBUG: TornadoRenderer render called for entity " + entity.getId());
        }
        super.render((Entity)entity, entityYaw, partialTicks, poseStack, buffer, packedLight);
        int tier = entity.getTier();
        double height = 30.0 + (double)tier * 15.0;
        double maxRadius = 20.0 + (double)tier * 5.0;
        float time = (float)entity.tickCount + partialTicks;
        double leanAngle = (double)time * 0.005;
        double leanMagnitude = Math.sin((double)time * 0.01) * (10.0 + (double)tier * 5.0);
        double leanX = Math.cos(leanAngle) * leanMagnitude;
        double leanZ = Math.sin(leanAngle) * leanMagnitude;
        poseStack.pushPose();
        this.renderLayer(poseStack, buffer.getBuffer(CORE_RENDER_TYPE), height, maxRadius, tier, time, leanX, leanZ, 1.0f, 1.0f, packedLight, false);
        poseStack.popPose();
    }

    private void renderLayer(PoseStack poseStack, VertexConsumer consumer, double height, double maxRadius, int tier, float time, double leanX, double leanZ, float radiusScale, float alpha, int packedLight, boolean reverseRotation) {
        int segments = (int)height;
        for (int i = 0; i < segments; ++i) {
            float yBottom = i;
            float yTop = i + 1;
            float progressBottom = yBottom / (float)height;
            float progressTop = yTop / (float)height;
            float baseRadius = (2.0f + (float)tier * 1.0f) * radiusScale;
            float radiusBottom = (float)((double)baseRadius + (maxRadius - (double)baseRadius) * Math.pow(progressBottom, 2.5));
            float radiusTop = (float)((double)baseRadius + (maxRadius - (double)baseRadius) * Math.pow(progressTop, 2.5));
            float bendFactorBottom = (float)Math.pow(progressBottom, 1.5);
            float bendFactorTop = (float)Math.pow(progressTop, 1.5);
            float wobbleXBottom = (float)(Math.sin((double)time * 0.02 + (double)yBottom * 0.05) * ((double)yBottom * 0.1));
            float wobbleZBottom = (float)(Math.cos((double)time * 0.02 + (double)yBottom * 0.05) * ((double)yBottom * 0.1));
            float wobbleXTop = (float)(Math.sin((double)time * 0.02 + (double)yTop * 0.05) * ((double)yTop * 0.1));
            float wobbleZTop = (float)(Math.cos((double)time * 0.02 + (double)yTop * 0.05) * ((double)yTop * 0.1));
            float xBottom = (float)(leanX * (double)bendFactorBottom + (double)wobbleXBottom);
            float zBottom = (float)(leanZ * (double)bendFactorBottom + (double)wobbleZBottom);
            float xTop = (float)(leanX * (double)bendFactorTop + (double)wobbleXTop);
            float zTop = (float)(leanZ * (double)bendFactorTop + (double)wobbleZTop);
            Matrix4f pose = poseStack.last().pose();
            this.drawSegment(pose, consumer, xBottom, yBottom, zBottom, radiusBottom, xTop, yTop, zTop, radiusTop, time, packedLight, alpha, reverseRotation);
        }
    }

    private void drawSegment(Matrix4f pose, VertexConsumer consumer, float x1, float y1, float z1, float r1, float x2, float y2, float z2, float r2, float time, int packedLight, float alpha, boolean reverseRotation) {
        int slices = 16;
        float textureScroll = time * 0.02f;
        if (reverseRotation) {
            textureScroll = -textureScroll;
        }
        for (int i = 0; i < slices; ++i) {
            float angle1 = (float)((double)(i * 2) * Math.PI / (double)slices);
            float angle2 = (float)((double)((i + 1) * 2) * Math.PI / (double)slices);
            float sin1 = Mth.sin((float)angle1);
            float cos1 = Mth.cos((float)angle1);
            float sin2 = Mth.sin((float)angle2);
            float cos2 = Mth.cos((float)angle2);
            float bx1 = x1 + cos1 * r1;
            float bz1 = z1 + sin1 * r1;
            float bx2 = x1 + cos2 * r1;
            float bz2 = z1 + sin2 * r1;
            float tx1 = x2 + cos1 * r2;
            float tz1 = z2 + sin1 * r2;
            float tx2 = x2 + cos2 * r2;
            float tz2 = z2 + sin2 * r2;
            float u1 = (float)i / (float)slices + textureScroll;
            float u2 = (float)(i + 1) / (float)slices + textureScroll;
            float v1 = y1 / 50.0f;
            float v2 = y2 / 50.0f;
            int alphaInt = (int)(alpha * 255.0f);
            consumer.addVertex(pose, bx1, y1, bz1).setColor(255, 255, 255, alphaInt).setUv(u1, v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(cos1, 0.0f, sin1);
            consumer.addVertex(pose, bx2, y1, bz2).setColor(255, 255, 255, alphaInt).setUv(u2, v1).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(cos2, 0.0f, sin2);
            consumer.addVertex(pose, tx2, y2, tz2).setColor(255, 255, 255, alphaInt).setUv(u2, v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(cos2, 0.0f, sin2);
            consumer.addVertex(pose, tx1, y2, tz1).setColor(255, 255, 255, alphaInt).setUv(u1, v2).setOverlay(OverlayTexture.NO_OVERLAY).setLight(packedLight).setNormal(cos1, 0.0f, sin1);
        }
    }

    public boolean shouldRender(TornadoEntity livingEntity, Frustum camera, double camX, double camY, double camZ) {
        return true;
    }

    public ResourceLocation getTextureLocation(TornadoEntity entity) {
        return CORE_TEXTURE;
    }
}

