/*
 * Decompiled with CFR 0.152.
 */
package com.example.examplemod;

import com.example.examplemod.ModSounds;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;

public class TornadoEntity
extends Entity {
    private static final EntityDataAccessor<Integer> TIER = SynchedEntityData.defineId(TornadoEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private int wanderTimer = 0;
    private Vec3 wanderTarget = Vec3.ZERO;

    public TornadoEntity(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(TIER, (Object)1);
    }

    protected void readAdditionalSaveData(CompoundTag compound) {
        this.entityData.set(TIER, (Object)compound.getInt("Tier"));
    }

    protected void addAdditionalSaveData(CompoundTag compound) {
        compound.putInt("Tier", this.getTier());
    }

    public void setTier(int tier) {
        this.entityData.set(TIER, (Object)tier);
    }

    public int getTier() {
        return (Integer)this.entityData.get(TIER);
    }

    public void tick() {
        super.tick();
        if (!this.level().isClientSide) {
            this.moveTornado();
            this.pullEntities();
            this.breakBlocks();
        } else {
            this.spawnParticles();
            this.playAmbientSound();
        }
    }

    public boolean shouldRenderAtSqrDistance(double distance) {
        double maxDist = 512.0 * (double)this.getTier();
        return distance < maxDist * maxDist;
    }

    private void playAmbientSound() {
        LocalPlayer clientPlayer;
        if (this.tickCount % 60 == 0) {
            this.level().playLocalSound(this.getX(), this.getY(), this.getZ(), (SoundEvent)ModSounds.TORNADO_ROAR.get(), SoundSource.WEATHER, 10.0f, 0.8f, false);
        }
        if ((clientPlayer = Minecraft.getInstance().player) != null && clientPlayer.distanceToSqr((Entity)this) < 6400.0 && this.tickCount % 100 == 0) {
            this.level().playLocalSound(clientPlayer.getX(), clientPlayer.getY(), clientPlayer.getZ(), (SoundEvent)ModSounds.TORNADO_SIREN.get(), SoundSource.WEATHER, 1.0f, 1.0f, false);
        }
    }

    private void moveTornado() {
        if (this.wanderTimer <= 0 || this.wanderTarget.distanceToSqr(this.position()) < 4.0) {
            this.wanderTimer = 200 + this.random.nextInt(200);
            double angle = this.random.nextDouble() * 2.0 * Math.PI;
            double distance = 10.0 + this.random.nextDouble() * 20.0;
            this.wanderTarget = this.position().add(Math.cos(angle) * distance, 0.0, Math.sin(angle) * distance);
        }
        --this.wanderTimer;
        Vec3 currentPos = this.position();
        Vec3 target2D = new Vec3(this.wanderTarget.x, currentPos.y, this.wanderTarget.z);
        Vec3 direction = target2D.subtract(currentPos).normalize().scale(0.15 * (1.0 + (double)this.getTier() * 0.1));
        int groundY = this.getAverageGroundY(this.blockPosition().getX(), this.blockPosition().getZ(), 2);
        double yDiff = (double)groundY - currentPos.y;
        double yVel = 0.0;
        if (Math.abs(yDiff) > 0.1) {
            yVel = yDiff * 0.1;
        }
        this.setDeltaMovement(direction.x, yVel, direction.z);
        this.move(MoverType.SELF, this.getDeltaMovement());
    }

    private int getAverageGroundY(int centerX, int centerZ, int radius) {
        int maxY = Integer.MIN_VALUE;
        boolean count = false;
        for (int x = centerX - radius; x <= centerX + radius; x += 2) {
            for (int z = centerZ - radius; z <= centerZ + radius; z += 2) {
                int y = this.getGroundY(x, z);
                if (y <= maxY) continue;
                maxY = y;
            }
        }
        return maxY;
    }

    private int getGroundY(int x, int z) {
        int y;
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(x, y, z);
        for (y = this.level().getHeight(Heightmap.Types.MOTION_BLOCKING, x, z); y > this.level().getMinBuildHeight(); --y) {
            pos.setY(y - 1);
            BlockState state = this.level().getBlockState((BlockPos)pos);
            if (!this.isTerrain(state)) continue;
            return y;
        }
        return this.level().getHeight(Heightmap.Types.MOTION_BLOCKING_NO_LEAVES, x, z);
    }

    private boolean isTerrain(BlockState state) {
        return state.is(BlockTags.DIRT) || state.is(BlockTags.SAND) || state.is(BlockTags.BASE_STONE_OVERWORLD) || state.is(BlockTags.BASE_STONE_NETHER) || state.is(Blocks.GRAVEL) || state.is(Blocks.CLAY) || state.is(Blocks.SNOW_BLOCK) || state.is(Blocks.ICE) || state.is(Blocks.PACKED_ICE) || state.is(Blocks.BLUE_ICE) || state.is(Blocks.WATER) || state.is(Blocks.MUD) || state.is(Blocks.MOSS_BLOCK) || state.is(Blocks.GRASS_BLOCK) || state.is(Blocks.PODZOL) || state.is(Blocks.COARSE_DIRT) || state.is(Blocks.MYCELIUM) || state.is(Blocks.BEDROCK);
    }

    private void pullEntities() {
        int tier = this.getTier();
        double radius = 15.0 + (double)tier * 5.0;
        double height = 30.0 + (double)tier * 10.0;
        AABB area = this.getBoundingBox().inflate(radius, height, radius);
        List entities = this.level().getEntities((Entity)this, area, e -> e instanceof LivingEntity || e instanceof FallingBlockEntity);
        for (Entity entity : entities) {
            Player player;
            if (entity instanceof Player && ((player = (Player)entity).isCreative() || player.isSpectator()) || entity.getTags().contains("TornadoEjected")) continue;
            Vec3 vecToCenter = this.position().subtract(entity.position());
            vecToCenter = new Vec3(vecToCenter.x, 0.0, vecToCenter.z);
            double distance = vecToCenter.length();
            if (distance < 0.1) continue;
            if (entity instanceof FallingBlockEntity) {
                this.handleFallingBlockPhysics((FallingBlockEntity)entity, vecToCenter, distance, height);
                continue;
            }
            Vec3 pull = vecToCenter.normalize().scale(0.25 + (double)tier * 0.05);
            Vec3 lift = new Vec3(0.0, 0.08 + (double)tier * 0.02, 0.0);
            Vec3 spiral = new Vec3(-vecToCenter.z, 0.0, vecToCenter.x).normalize().scale(0.4);
            Vec3 totalForce = pull.add(lift).add(spiral);
            Vec3 currentVel = entity.getDeltaMovement();
            entity.setDeltaMovement(currentVel.add(totalForce));
            entity.hurtMarked = true;
        }
    }

    private void handleFallingBlockPhysics(FallingBlockEntity entity, Vec3 vecToCenter, double distance, double maxHeight) {
        Vec3 tangent = new Vec3(-vecToCenter.z, 0.0, vecToCenter.x).normalize();
        double targetRadius = 5.0 + (entity.getY() - this.getY()) * 0.3;
        Vec3 radial = vecToCenter.normalize();
        if (distance < targetRadius) {
            radial = radial.scale(-1.0);
        }
        double liftScale = 0.2;
        boolean eject = false;
        if (entity.getY() > this.getY() + maxHeight * 0.8) {
            liftScale = 0.5;
            radial = radial.scale(-2.0);
            eject = true;
        }
        Vec3 currentVel = entity.getDeltaMovement();
        Vec3 orbitForce = tangent.scale(0.3);
        Vec3 radialForce = radial.scale(0.1);
        Vec3 liftForce = new Vec3(0.0, liftScale, 0.0);
        Vec3 newVel = currentVel.scale(0.9).add(orbitForce).add(radialForce).add(liftForce);
        entity.setDeltaMovement(newVel);
        if (eject) {
            entity.addTag("TornadoEjected");
        }
    }

    private void breakBlocks() {
        int tier = this.getTier();
        if (this.random.nextInt(2) != 0) {
            return;
        }
        int radius = 3 + tier;
        int attempts = 5 + tier * 10;
        int depth = tier * 2;
        for (int i = 0; i < attempts; ++i) {
            FallingBlockEntity fallingBlock;
            int x = Mth.floor((double)(this.getX() + (double)this.random.nextInt(radius * 2 + 1) - (double)radius));
            int yOffset = this.random.nextInt(depth + 5) - depth;
            int y = Mth.floor((double)(this.getY() + (double)yOffset));
            int z = Mth.floor((double)(this.getZ() + (double)this.random.nextInt(radius * 2 + 1) - (double)radius));
            BlockPos pos = new BlockPos(x, y, z);
            BlockState state = this.level().getBlockState(pos);
            if (state.isAir() || !(state.getDestroySpeed((BlockGetter)this.level(), pos) >= 0.0f) || !((double)state.getDestroySpeed((BlockGetter)this.level(), pos) < 50.0) || (fallingBlock = FallingBlockEntity.fall((Level)this.level(), (BlockPos)pos, (BlockState)state)) == null) continue;
            fallingBlock.setDeltaMovement(0.0, 0.5, 0.0);
            fallingBlock.dropItem = false;
        }
    }

    private void spawnParticles() {
        int tier = this.getTier();
        double height = 20.0 + (double)tier * 10.0;
        double maxRadius = 8.0 + (double)tier * 3.0;
        for (double y = 0.0; y < height; y += 0.5) {
            double progress = y / height;
            double radius = 1.0 + progress * maxRadius;
            double time = this.tickCount;
            double wobbleX = Math.sin(time * 0.05 + y * 0.15) * (y * 0.2);
            double wobbleZ = Math.cos(time * 0.04 + y * 0.12) * (y * 0.2);
            int particlesPerLayer = (int)(radius * 4.0);
            for (int i = 0; i < particlesPerLayer; ++i) {
                double angle = (double)i / (double)particlesPerLayer * 2.0 * Math.PI + time * 0.1;
                double x = Math.cos(angle) * radius + wobbleX;
                double z = Math.sin(angle) * radius + wobbleZ;
                double rotSpeed = 0.2;
                double vx = -Math.sin(angle) * rotSpeed;
                double vz = Math.cos(angle) * rotSpeed;
                if (this.random.nextInt(10) == 0) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.CLOUD, true, this.getX() + x, this.getY() + y, this.getZ() + z, vx, 0.0, vz);
                }
                if (this.random.nextInt(20) != 0) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.LARGE_SMOKE, true, this.getX() + x, this.getY() + y, this.getZ() + z, vx, 0.0, vz);
            }
        }
        for (int i = 0; i < 5; ++i) {
            double r = this.random.nextDouble() * (double)(3 + tier);
            double ang = this.random.nextDouble() * 2.0 * Math.PI;
            double vx = -Math.sin(ang) * 0.1;
            double vz = Math.cos(ang) * 0.1;
            this.level().addParticle((ParticleOptions)ParticleTypes.CAMPFIRE_COSY_SMOKE, true, this.getX() + Math.cos(ang) * r, this.getY(), this.getZ() + Math.sin(ang) * r, vx, 0.1, vz);
        }
    }
}

