package de.rubixdev.yarrp.mixin;

import de.rubixdev.yarrp.ModConstants;
import de.rubixdev.yarrp.api.PackPosition;
import de.rubixdev.yarrp.api.YarrpCallbacks;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Consumer;
import net.minecraft.class_3264;
import net.minecraft.class_3279;
import net.minecraft.class_3285;
import net.minecraft.class_3288;

@Mixin(class_3279.class)
public abstract class FolderRepositorySourceMixin implements class_3285 {
    @Shadow
    @Final
    private class_3264 packType;

    @Inject(method = "loadPacks", at = @At("HEAD"))
    public void yarrp$injectPacks(Consumer<class_3288> consumer, CallbackInfo ci) {
        ModConstants.LOGGER.debug("Registering BEFORE_USER packs with type {}", packType);
        YarrpCallbacks.run(
            PackPosition.BEFORE_USER,
            packType,
            YarrpCallbacks.wrapPackConsumer(consumer, packType, class_3288.class_3289.field_14281)
        );
        YarrpCallbacks.run(
            PackPosition.AFTER_USER,
            packType,
            YarrpCallbacks.wrapPackConsumer(consumer, packType, class_3288.class_3289.field_14280)
        );
    }
}
