package de.rubixdev.yarrp.mixin;

import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import de.rubixdev.yarrp.api.DummyHolderSet;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

import java.util.List;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6898;

@Mixin(class_6898.class)
public abstract class HolderSetCodecMixin<E> implements Codec<class_6885<E>> {
    @Shadow
    @Final
    private Codec<Either<class_6862<E>, List<class_6880<E>>>> registryAwareCodec;

    @Inject(
        method = "encode(Lnet/minecraft/core/HolderSet;Lcom/mojang/serialization/DynamicOps;Ljava/lang/Object;)Lcom/mojang/serialization/DataResult;",
        at = @At("HEAD"),
        cancellable = true
    )
    public <T> void encodeDummySet(
        class_6885<E> input,
        DynamicOps<T> ops,
        T prefix,
        CallbackInfoReturnable<DataResult<T>> cir
    ) {
        if (input instanceof DummyHolderSet<E>) {
            cir.setReturnValue(registryAwareCodec.encode(input.method_40248().mapRight(List::copyOf), ops, prefix));
        }
    }
}
