package de.rubixdev.yarrp.mixin;

import com.google.common.collect.Lists;
import de.rubixdev.yarrp.ModConstants;
import de.rubixdev.yarrp.api.YarrpCallbacks;
import de.rubixdev.yarrp.api.PackPosition;
import kotlin.Unit;
import net.minecraft.class_3262;
import net.minecraft.class_3264;
import net.minecraft.class_6860;
import net.minecraft.class_6861;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.ModifyVariable;

import java.util.ArrayList;
import java.util.List;

@Mixin(class_6861.class)
public abstract class MultiPackResourceManagerMixin implements class_6860 {
    @ModifyVariable(method = "<init>", at = @At("HEAD"), argsOnly = true)
    private static List<class_3262> yarrp$injectPacks(List<class_3262> packs, class_3264 type) {
        var copy = new ArrayList<>(packs);
        var reversedView = Lists.reverse(copy);

        ModConstants.LOGGER.debug("Registering BEFORE_VANILLA packs");
        YarrpCallbacks.run(PackPosition.BEFORE_VANILLA, pack -> {
            reversedView.add(pack);
            return Unit.INSTANCE;
        });

        ModConstants.LOGGER.debug("Registering AFTER_VANILLA packs");
        YarrpCallbacks.run(PackPosition.BEFORE_VANILLA, pack -> {
            copy.add(pack);
            return Unit.INSTANCE;
        });

        return copy;
    }
}
