package de.lulkas_.vanilla_addons.datagen;

import de.lulkas_.vanilla_addons.item.ModItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricRecipeProvider;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2447;
import net.minecraft.class_7225;
import net.minecraft.class_7800;
import net.minecraft.class_8790;
import java.util.concurrent.CompletableFuture;

public class ModRecipeProvider extends FabricRecipeProvider {
    public ModRecipeProvider(FabricDataOutput output, CompletableFuture<class_7225.class_7874> registriesFuture) {
        super(output, registriesFuture);
    }

    @Override
    public void method_10419(class_8790 exporter) {
        method_36325(exporter, class_7800.field_40642, class_1802.field_8733, class_7800.field_40642, ModItems.COMPRESSED_EMERALD);

        offerArmorRecipe(ModItems.COMPRESSED_EMERALD, ModItems.EMERALD_BOOTS, ModItems.EMERALD_LEGGINGS, ModItems.EMERALD_CHESTPLATE, ModItems.EMERALD_HELMET, exporter);
        offerArmorRecipe(class_1802.field_22020, class_1802.field_22030, class_1802.field_22029, class_1802.field_22028, class_1802.field_22027, exporter);
        offerArmorRecipe(class_1802.field_23983, class_1802.field_8313, class_1802.field_8218, class_1802.field_8873, class_1802.field_8283, exporter);
        offerArmorRecipe(class_1802.field_27022, ModItems.COPPER_BOOTS, ModItems.COPPER_LEGGINGS, ModItems.COPPER_CHESTPLATE, ModItems.COPPER_HELMET, exporter);
        offerArmorRecipe(class_1802.field_8161, ModItems.TURTLE_BOOTS, ModItems.TURTLE_LEGGINGS, ModItems.TURTLE_CHESTPLATE, null, exporter);

        offerToolRecipe(ModItems.COMPRESSED_EMERALD, ModItems.EMERALD_SWORD, ModItems.EMERALD_PICKAXE, ModItems.EMERALD_AXE, ModItems.EMERALD_SHOVEL, ModItems.EMERALD_HOE, exporter);
        offerToolRecipe(ModItems.COMPRESSED_EMERALD, ModItems.COPPER_SWORD, ModItems.COPPER_PICKAXE, ModItems.COPPER_AXE, ModItems.COPPER_SHOVEL, ModItems.COPPER_HOE, exporter);
    }

    public static void offerArmorRecipe(class_1935 material, class_1935 boots, class_1935 leggings, class_1935 chestplate, class_1935 helmet, class_8790 exporter) {
        if(boots != null) {
            class_2447.method_10437(class_7800.field_40639, boots)
                    .method_10439("E E")
                    .method_10439("E E")
                    .method_10434('E', material)
                    .method_10429(method_32807(material), method_10426(material))
                    .method_10431(exporter);
        }
        if(leggings != null) {
            class_2447.method_10437(class_7800.field_40639, leggings)
                    .method_10439("EEE")
                    .method_10439("E E")
                    .method_10439("E E")
                    .method_10434('E', material)
                    .method_10429(method_32807(material), method_10426(material))
                    .method_10431(exporter);
        }
        if(chestplate != null) {
            class_2447.method_10437(class_7800.field_40639, chestplate)
                    .method_10439("E E")
                    .method_10439("EEE")
                    .method_10439("EEE")
                    .method_10434('E', material)
                    .method_10429(method_32807(material), method_10426(material))
                    .method_10431(exporter);
        }
        if(helmet != null) {
            class_2447.method_10437(class_7800.field_40639, helmet)
                    .method_10439("EEE")
                    .method_10439("E E")
                    .method_10434('E', material)
                    .method_10429(method_32807(material), method_10426(material))
                    .method_10431(exporter);
        }
    }

    public static void offerToolRecipe(class_1935 material, class_1935 sword, class_1935 pickaxe, class_1935 axe, class_1935 shovel, class_1935 hoe, class_8790 exporter) {
        if(sword != null) {
            class_2447.method_10437(class_7800.field_40639, sword)
                    .method_10439("E")
                    .method_10439("E")
                    .method_10439("S")
                    .method_10434('S', class_1802.field_8600)
                    .method_10434('E', material)
                    .method_10429(method_32807(material), method_10426(material))
                    .method_10431(exporter);
        }
        if(pickaxe != null) {
            class_2447.method_10437(class_7800.field_40639, pickaxe)
                    .method_10439("EEE")
                    .method_10439(" S ")
                    .method_10439(" S ")
                    .method_10434('S', class_1802.field_8600)
                    .method_10434('E', material)
                    .method_10429(method_32807(material), method_10426(material))
                    .method_10431(exporter);
        }
        if(axe != null) {
            class_2447.method_10437(class_7800.field_40639, axe)
                    .method_10439(" EE")
                    .method_10439(" SE")
                    .method_10439(" S ")
                    .method_10434('S', class_1802.field_8600)
                    .method_10434('E', material)
                    .method_10429(method_32807(material), method_10426(material))
                    .method_10431(exporter);
        }
        if(shovel != null) {
            class_2447.method_10437(class_7800.field_40639, shovel)
                    .method_10439("E")
                    .method_10439("S")
                    .method_10439("S")
                    .method_10434('S', class_1802.field_8600)
                    .method_10434('E', material)
                    .method_10429(method_32807(material), method_10426(material))
                    .method_10431(exporter);
        }
        if(hoe != null) {
            class_2447.method_10437(class_7800.field_40639, hoe)
                    .method_10439(" EE")
                    .method_10439(" S ")
                    .method_10439(" S ")
                    .method_10434('S', class_1802.field_8600)
                    .method_10434('E', material)
                    .method_10429(method_32807(material), method_10426(material))
                    .method_10431(exporter);
        }
    }
}
