package de.lulkas_.vanilla_addons.item;

import de.lulkas_.vanilla_addons.VanillaAddons;
import de.lulkas_.vanilla_addons.item.custom.EmeraldArmorItem;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricLanguageProvider;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1743;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1810;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_4915;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_7923;
import net.minecraft.item.*;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ModItems {
    private static final Map<class_1792, class_4942> itemModelMap = new HashMap<>();
    private static final List<class_1792> items = new ArrayList<>();
    private static final Map<String, String> keyToTranslationMap = new HashMap<>();

    public static final class_1792 COMPRESSED_EMERALD = registerItem("compressed_emerald", "Compressed Emerald", class_4943.field_22938,
            new class_1792(new class_1792.class_1793()));

    public static final class_1792 EMERALD_BOOTS = registerItem("emerald_boots", "Emerald Boots", null,
            new EmeraldArmorItem(ModArmorMaterials.EMERALD_ARMOR_MATERIAL, class_1738.class_8051.field_41937,
                    new class_1792.class_1793().method_7895(class_1738.class_8051.field_41937.method_56690(15))));
    public static final class_1792 EMERALD_LEGGINGS = registerItem("emerald_leggings", "Emerald Leggings", null,
            new EmeraldArmorItem(ModArmorMaterials.EMERALD_ARMOR_MATERIAL, class_1738.class_8051.field_41936,
                    new class_1792.class_1793().method_7895(class_1738.class_8051.field_41936.method_56690(15))));
    public static final class_1792 EMERALD_CHESTPLATE = registerItem("emerald_chestplate", "Emerald Chestplate", null,
            new EmeraldArmorItem(ModArmorMaterials.EMERALD_ARMOR_MATERIAL, class_1738.class_8051.field_41935,
                    new class_1792.class_1793().method_7895(class_1738.class_8051.field_41935.method_56690(15))));
    public static final class_1792 EMERALD_HELMET = registerItem("emerald_helmet", "Emerald Helmet", null,
            new EmeraldArmorItem(ModArmorMaterials.EMERALD_ARMOR_MATERIAL, class_1738.class_8051.field_41934,
                    new class_1792.class_1793().method_7895(class_1738.class_8051.field_41934.method_56690(15))));

    public static final class_1792 COPPER_BOOTS = registerItem("copper_boots", "Copper Boots", null,
            new class_1738(ModArmorMaterials.COPPER_ARMOR_MATERIAL, class_1738.class_8051.field_41937,
                    new class_1792.class_1793().method_7895(class_1738.class_8051.field_41937.method_56690(10))));
    public static final class_1792 COPPER_LEGGINGS = registerItem("copper_leggings", "Copper Leggings", null,
            new class_1738(ModArmorMaterials.COPPER_ARMOR_MATERIAL, class_1738.class_8051.field_41936,
                    new class_1792.class_1793().method_7895(class_1738.class_8051.field_41936.method_56690(10))));
    public static final class_1792 COPPER_CHESTPLATE = registerItem("copper_chestplate", "Copper Chestplate", null,
            new class_1738(ModArmorMaterials.COPPER_ARMOR_MATERIAL, class_1738.class_8051.field_41935,
                    new class_1792.class_1793().method_7895(class_1738.class_8051.field_41935.method_56690(10))));
    public static final class_1792 COPPER_HELMET = registerItem("copper_helmet", "Copper Helmet", null,
            new class_1738(ModArmorMaterials.COPPER_ARMOR_MATERIAL, class_1738.class_8051.field_41934,
                    new class_1792.class_1793().method_7895(class_1738.class_8051.field_41934.method_56690(10))));

    public static final class_1792 TURTLE_BOOTS = registerItem("turtle_boots", "Turtle Boots", null,
            new class_1738(class_1740.field_7890, class_1738.class_8051.field_41937, new class_1792.class_1793().method_7895(class_1738.class_8051.field_41937.method_56690(25))));
    public static final class_1792 TURTLE_LEGGINGS = registerItem("turtle_leggings", "Turtle Leggings", null,
            new class_1738(class_1740.field_7890, class_1738.class_8051.field_41936, new class_1792.class_1793().method_7895(class_1738.class_8051.field_41936.method_56690(25))));
    public static final class_1792 TURTLE_CHESTPLATE = registerItem("turtle_chestplate", "Turtle Chestplate", null,
            new class_1738(class_1740.field_7890, class_1738.class_8051.field_41935, new class_1792.class_1793().method_7895(class_1738.class_8051.field_41935.method_56690(25))));

    public static final class_1792 EMERALD_SWORD = registerItem("emerald_sword", "Emerald Sword", class_4943.field_22939,
            new class_1829(ModToolMaterials.EMERALD, new class_1792.class_1793().method_57348(class_1829.method_57394(ModToolMaterials.EMERALD, 3, -2.4f))));
    public static final class_1792 EMERALD_PICKAXE = registerItem("emerald_pickaxe", "Emerald Pickaxe", class_4943.field_22939,
            new class_1810(ModToolMaterials.EMERALD, new class_1792.class_1793().method_57348(class_1810.method_57346(ModToolMaterials.EMERALD, 1, -2.8f))));
    public static final class_1792 EMERALD_AXE = registerItem("emerald_axe", "Emerald Axe", class_4943.field_22939,
            new class_1743(ModToolMaterials.EMERALD, new class_1792.class_1793().method_57348(class_1743.method_57346(ModToolMaterials.EMERALD, 6f, -3.2f))));
    public static final class_1792 EMERALD_SHOVEL = registerItem("emerald_shovel", "Emerald Shovel", class_4943.field_22939,
            new class_1821(ModToolMaterials.EMERALD, new class_1792.class_1793().method_57348(class_1821.method_57346(ModToolMaterials.EMERALD, 1.5f, -3f))));
    public static final class_1792 EMERALD_HOE = registerItem("emerald_hoe", "Emerald Hoe", class_4943.field_22939,
            new class_1794(ModToolMaterials.EMERALD, new class_1792.class_1793().method_57348(class_1794.method_57346(ModToolMaterials.EMERALD, 0, -3f))));

    public static final class_1792 COPPER_SWORD = registerItem("copper_sword", "Copper Sword", class_4943.field_22939,
            new class_1829(ModToolMaterials.COPPER, new class_1792.class_1793().method_57348(class_1829.method_57394(ModToolMaterials.COPPER, 3, -2.4f))));
    public static final class_1792 COPPER_PICKAXE = registerItem("copper_pickaxe", "Copper Pickaxe", class_4943.field_22939,
            new class_1810(ModToolMaterials.COPPER, new class_1792.class_1793().method_57348(class_1810.method_57346(ModToolMaterials.COPPER, 1, -2.8f))));
    public static final class_1792 COPPER_AXE = registerItem("copper_axe", "Copper Axe", class_4943.field_22939,
            new class_1743(ModToolMaterials.COPPER, new class_1792.class_1793().method_57348(class_1743.method_57346(ModToolMaterials.COPPER, 6f, -3.2f))));
    public static final class_1792 COPPER_SHOVEL = registerItem("copper_shovel", "Copper Shovel", class_4943.field_22939,
            new class_1821(ModToolMaterials.COPPER, new class_1792.class_1793().method_57348(class_1821.method_57346(ModToolMaterials.COPPER, 1.5f, -3f))));
    public static final class_1792 COPPER_HOE = registerItem("copper_hoe", "Copper Hoe", class_4943.field_22939,
            new class_1794(ModToolMaterials.COPPER, new class_1792.class_1793().method_57348(class_1794.method_57346(ModToolMaterials.COPPER, 0, -3f))));

    private static class_1792 registerItem(String name, String translation, class_4942 model, class_1792 item) {
        if(model != null) {
            itemModelMap.put(item, model);
        }
        items.add(item);
        keyToTranslationMap.put("item." + VanillaAddons.MOD_ID + "." + name, translation);
        return class_2378.method_10230(class_7923.field_41178, class_2960.method_60655(VanillaAddons.MOD_ID, name), item);
    }

    public static void addItemGroupEntries(class_1761.class_7704 entries) {
        for(class_1792 item : items) {
            entries.method_45421(item);
        }
    }

    public static void generateTranslations(FabricLanguageProvider.TranslationBuilder translationBuilder) {
        for(Map.Entry<String, String> item : keyToTranslationMap.entrySet()) {
            translationBuilder.add(item.getKey(), item.getValue());
        }
    }

    public static void generateDefaultItemModels(class_4915 itemModelGenerator) {
        for(Map.Entry<class_1792, class_4942> item : itemModelMap.entrySet()) {
            itemModelGenerator.method_25733(item.getKey(), item.getValue());
        }
    }

    public static void registerModItems() {
        VanillaAddons.LOGGER.info("Registering Items of " + VanillaAddons.MOD_ID + " Mod");
    }
}
