/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.bungee;

import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.md_5.bungee.api.ChatColor;
import net.md_5.bungee.api.CommandSender;
import net.md_5.bungee.api.chat.BaseComponent;
import net.md_5.bungee.api.chat.TextComponent;
import net.md_5.bungee.api.connection.ProxiedPlayer;
import net.md_5.bungee.api.plugin.Command;
import net.md_5.bungee.api.plugin.Listener;
import net.md_5.bungee.api.plugin.Plugin;
import net.md_5.bungee.api.plugin.PluginManager;
import xyz.lychee.gatekeeper.bungee.BungeeCommand;
import xyz.lychee.gatekeeper.bungee.BungeeListeners;
import xyz.lychee.gatekeeper.libs.metrics.bungeecord.Metrics;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.checks.BlacklistCheck;
import xyz.lychee.gatekeeper.shared.manager.ChecksManager;
import xyz.lychee.gatekeeper.shared.manager.ConfigManager;
import xyz.lychee.gatekeeper.shared.manager.DataManager;
import xyz.lychee.gatekeeper.shared.manager.GeoipManager;
import xyz.lychee.gatekeeper.shared.manager.TaskManager;
import xyz.lychee.gatekeeper.shared.objects.AbstractLang;
import xyz.lychee.gatekeeper.shared.objects.CommandPlayer;
import xyz.lychee.gatekeeper.shared.objects.EnumAccess;
import xyz.lychee.gatekeeper.shared.util.AddressUtils;

public class BungeeMain
extends Plugin
implements Gatekeeper<BaseComponent>,
Listener {
    private Metrics metrics;
    private AbstractLang<BaseComponent> language;

    public void onEnable() {
        try {
            this.metrics = new Metrics(this, 27413);
            this.language = new BungeeLang(this);
            ConfigManager.INSTANCE.loadConfig(this);
            DataManager.INSTANCE.loadDatabase(this);
            ChecksManager.INSTANCE.loadChecks(this);
            GeoipManager.INSTANCE.loadDatabases(this);
            TaskManager.INSTANCE.loadTasks(this);
            this.language.loadLanguage();
            PluginManager pm = this.getProxy().getPluginManager();
            pm.registerListener((Plugin)this, (Listener)new BungeeListeners());
            pm.registerCommand((Plugin)this, (Command)new BungeeCommand(this));
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load plugin", e);
        }
    }

    public void onDisable() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    @Override
    public InputStream resource(String name) {
        return this.getResourceAsStream(name);
    }

    @Override
    public File dataFolder() {
        return this.getDataFolder();
    }

    @Override
    public Logger logger() {
        return this.getLogger();
    }

    @Override
    public AbstractLang<BaseComponent> language() {
        return this.language;
    }

    @Override
    public CommandPlayer<BaseComponent> commandPlayer(Object player) {
        return new CommandPlayer<BaseComponent>(player){

            @Override
            public boolean hasPermission(String permission) {
                if (this.getPlayer() instanceof CommandSender) {
                    return ((CommandSender)this.getPlayer()).hasPermission(permission);
                }
                return false;
            }

            @Override
            public void sendMessage(BaseComponent message) {
                if (this.getPlayer() instanceof CommandSender) {
                    ((CommandSender)this.getPlayer()).sendMessage(message);
                }
            }

            @Override
            public void applyChange(String target, EnumAccess newAccess) {
                ProxiedPlayer player2;
                BlacklistCheck check = ChecksManager.INSTANCE.getCheck(BlacklistCheck.class);
                Object kickMessage = check.getKickMessage();
                try {
                    if (AddressUtils.isIpAddress(target)) {
                        InetAddress addr = InetAddress.getByAddress(AddressUtils.parseIp(target));
                        DataManager.INSTANCE.setAccess(AddressUtils.addressToInteger(addr), newAccess);
                        if (newAccess == EnumAccess.BLACKLIST && kickMessage instanceof BaseComponent) {
                            BaseComponent baseComponent = (BaseComponent)kickMessage;
                            BungeeMain.this.getProxy().getPlayers().stream().filter(player -> player.getAddress().getAddress().equals(addr)).forEach(player -> player.disconnect(baseComponent));
                        }
                        return;
                    }
                }
                catch (Exception addr) {
                    // empty catch block
                }
                DataManager.INSTANCE.setAccess(target, newAccess);
                if (newAccess == EnumAccess.BLACKLIST && kickMessage instanceof BaseComponent && (player2 = BungeeMain.this.getProxy().getPlayer(target)) != null) {
                    BaseComponent baseComponent = (BaseComponent)kickMessage;
                    player2.disconnect(baseComponent);
                }
            }
        };
    }

    public static class BungeeLang
    extends AbstractLang<BaseComponent> {
        private final Pattern hexPattern = Pattern.compile("&#([A-Fa-f0-9]{6})");
        private final boolean singleBase;

        public BungeeLang(BungeeMain gatekeeper) {
            super(gatekeeper);
            boolean singleBase = false;
            try {
                TextComponent.fromLegacy((String)"test");
                singleBase = true;
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.singleBase = singleBase;
        }

        @Override
        public BaseComponent color(String text, boolean prefix) {
            String colored = this.applyColors(text);
            if (prefix && ConfigManager.INSTANCE.getPrefix() instanceof BaseComponent) {
                TextComponent root = new TextComponent();
                BaseComponent p = (BaseComponent)ConfigManager.INSTANCE.getPrefix();
                String[] parts = colored.split("%prefix%", -1);
                for (int i = 0; i < parts.length; ++i) {
                    if (!parts[i].isEmpty()) {
                        if (this.singleBase) {
                            root.addExtra(TextComponent.fromLegacy((String)parts[i]));
                        } else {
                            for (BaseComponent bc : TextComponent.fromLegacyText((String)parts[i])) {
                                root.addExtra(bc);
                            }
                        }
                    }
                    if (i >= parts.length - 1) continue;
                    root.addExtra(p);
                }
                return root;
            }
            if (this.singleBase) {
                return TextComponent.fromLegacy((String)colored);
            }
            TextComponent root = new TextComponent();
            for (BaseComponent bc : TextComponent.fromLegacyText((String)colored)) {
                root.addExtra(bc);
            }
            return root;
        }

        private String applyColors(String message) {
            Matcher matcher = this.hexPattern.matcher(message);
            StringBuffer buffer = new StringBuffer();
            while (matcher.find()) {
                String hex = matcher.group(1);
                StringBuilder replacement = new StringBuilder("&x");
                for (char c : hex.toCharArray()) {
                    replacement.append('&').append(c);
                }
                matcher.appendReplacement(buffer, replacement.toString());
            }
            matcher.appendTail(buffer);
            return ChatColor.translateAlternateColorCodes((char)'&', (String)buffer.toString());
        }
    }
}

