/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.paper;

import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentLike;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.TextReplacementConfig;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import xyz.lychee.gatekeeper.libs.metrics.bukkit.Metrics;
import xyz.lychee.gatekeeper.paper.PaperCommand;
import xyz.lychee.gatekeeper.paper.PaperListeners;
import xyz.lychee.gatekeeper.shared.Gatekeeper;
import xyz.lychee.gatekeeper.shared.checks.BlacklistCheck;
import xyz.lychee.gatekeeper.shared.manager.ChecksManager;
import xyz.lychee.gatekeeper.shared.manager.ConfigManager;
import xyz.lychee.gatekeeper.shared.manager.DataManager;
import xyz.lychee.gatekeeper.shared.manager.GeoipManager;
import xyz.lychee.gatekeeper.shared.manager.TaskManager;
import xyz.lychee.gatekeeper.shared.objects.AbstractLang;
import xyz.lychee.gatekeeper.shared.objects.CommandPlayer;
import xyz.lychee.gatekeeper.shared.objects.EnumAccess;
import xyz.lychee.gatekeeper.shared.util.AddressUtils;

public class PaperMain
extends JavaPlugin
implements Gatekeeper<Component>,
Listener {
    private final LegacyComponentSerializer serializer = LegacyComponentSerializer.builder().character('&').hexCharacter('#').hexColors().useUnusualXRepeatedCharacterHexFormat().build();
    private Metrics metrics;
    private AbstractLang<Component> language;

    public void onEnable() {
        try {
            this.metrics = new Metrics((Plugin)this, 27416);
            this.language = new PaperLang(this);
            ConfigManager.INSTANCE.loadConfig(this);
            DataManager.INSTANCE.loadDatabase(this);
            ChecksManager.INSTANCE.loadChecks(this);
            GeoipManager.INSTANCE.loadDatabases(this);
            TaskManager.INSTANCE.loadTasks(this);
            this.language.loadLanguage();
            PluginManager pm = Bukkit.getPluginManager();
            pm.registerEvents((Listener)new PaperListeners(), (Plugin)this);
            PaperCommand commandHandler = new PaperCommand(this);
            CommandMap commandMap = Bukkit.getServer().getCommandMap();
            commandMap.register("gatekeeper", (Command)commandHandler);
        }
        catch (Exception e) {
            this.getLogger().log(Level.SEVERE, "Failed to load plugin", e);
        }
    }

    public void onDisable() {
        if (this.metrics != null) {
            this.metrics.shutdown();
        }
    }

    @Override
    public InputStream resource(String name) {
        return this.getResource(name);
    }

    @Override
    public File dataFolder() {
        return this.getDataFolder();
    }

    @Override
    public Logger logger() {
        return this.getLogger();
    }

    @Override
    public AbstractLang<Component> language() {
        return this.language;
    }

    @Override
    public CommandPlayer<Component> commandPlayer(Object player) {
        return new CommandPlayer<Component>(player){

            @Override
            public boolean hasPermission(String permission) {
                if (this.getPlayer() instanceof CommandSender) {
                    return ((CommandSender)this.getPlayer()).hasPermission(permission);
                }
                return false;
            }

            @Override
            public void sendMessage(Component message) {
                if (this.getPlayer() instanceof CommandSender) {
                    ((CommandSender)this.getPlayer()).sendMessage(message);
                }
            }

            @Override
            public void applyChange(String target, EnumAccess newAccess) {
                BlacklistCheck check = ChecksManager.INSTANCE.getCheck(BlacklistCheck.class);
                Object kickMessage = check.getKickMessage();
                try {
                    if (AddressUtils.isIpAddress(target)) {
                        InetAddress addr = InetAddress.getByAddress(AddressUtils.parseIp(target));
                        DataManager.INSTANCE.setAccess(AddressUtils.addressToInteger(addr), newAccess);
                        if (newAccess == EnumAccess.BLACKLIST && kickMessage instanceof Component) {
                            Component component = (Component)kickMessage;
                            Bukkit.getOnlinePlayers().stream().filter(player -> player.getAddress().getAddress().equals(addr)).forEach(player -> player.kick(component));
                        }
                        return;
                    }
                }
                catch (Exception addr) {
                    // empty catch block
                }
                DataManager.INSTANCE.setAccess(target, newAccess);
                if (newAccess == EnumAccess.BLACKLIST && kickMessage instanceof Component) {
                    Component component = (Component)kickMessage;
                    Player player2 = Bukkit.getPlayer((String)target);
                    if (player2 != null) {
                        player2.kick(component);
                    }
                }
            }
        };
    }

    public class PaperLang
    extends AbstractLang<Component> {
        public PaperLang(PaperMain gatekeeper) {
            super(gatekeeper);
        }

        @Override
        public Component color(String text, boolean prefix) {
            Object object;
            TextComponent deserialized = PaperMain.this.serializer.deserialize(text);
            if (prefix && (object = ConfigManager.INSTANCE.getPrefix()) instanceof ComponentLike) {
                ComponentLike p = (ComponentLike)object;
                return deserialized.replaceText((TextReplacementConfig)TextReplacementConfig.builder().matchLiteral("%prefix%").replacement(p).build());
            }
            return deserialized;
        }
    }
}

