/*
 * Decompiled with CFR 0.152.
 */
package xyz.lychee.gatekeeper.shared.objects;

import dev.dejvokep.boostedyaml.YamlDocument;
import dev.dejvokep.boostedyaml.block.implementation.Section;
import dev.dejvokep.boostedyaml.settings.dumper.DumperSettings;
import dev.dejvokep.boostedyaml.settings.general.GeneralSettings;
import dev.dejvokep.boostedyaml.settings.loader.LoaderSettings;
import java.io.File;
import java.net.InetAddress;
import java.util.Collections;
import lombok.Generated;
import org.jetbrains.annotations.Nullable;
import xyz.lychee.gatekeeper.shared.Gatekeeper;

public abstract class AbstractCheck {
    private final Gatekeeper<?> gatekeeper;
    private final String name;
    private Section config;
    private boolean loaded = false;
    private int priority;
    private Object kickMessage;
    @Nullable
    private String logMessage;

    public AbstractCheck(Gatekeeper<?> gatekeeper, String name) {
        this.gatekeeper = gatekeeper;
        this.name = name;
    }

    public abstract boolean check(InetAddress var1, String var2, int var3);

    public void printCheck(InetAddress address, String name) {
        if (this.logMessage != null) {
            this.gatekeeper.logger().info(this.logMessage.replace("%name%", name).replace("%address%", address.getHostAddress()));
        }
    }

    public boolean loadAllConfig() throws Exception {
        String resourcePath = "checks/" + this.name + ".yml";
        File configFile = new File(this.gatekeeper.dataFolder(), resourcePath);
        YamlDocument yaml = YamlDocument.create(configFile, this.gatekeeper.resource(resourcePath), GeneralSettings.DEFAULT, LoaderSettings.builder().setAutoUpdate(true).build(), DumperSettings.DEFAULT);
        yaml.save();
        if (!yaml.getBoolean(this.name + ".enabled").booleanValue()) {
            return false;
        }
        this.config = yaml.getSection(this.name + ".values");
        this.priority = yaml.getInt(this.name + ".priority");
        String log = yaml.getString(this.name + ".log", "");
        this.logMessage = log.isEmpty() ? null : log;
        String kick = String.join((CharSequence)"\n", yaml.getStringList(this.name + ".kick", Collections.emptyList()));
        this.kickMessage = this.gatekeeper.language().color(kick, true);
        return this.load();
    }

    public abstract boolean load() throws Exception;

    @Generated
    public void setConfig(Section config) {
        this.config = config;
    }

    @Generated
    public void setLoaded(boolean loaded) {
        this.loaded = loaded;
    }

    @Generated
    public void setPriority(int priority) {
        this.priority = priority;
    }

    @Generated
    public void setKickMessage(Object kickMessage) {
        this.kickMessage = kickMessage;
    }

    @Generated
    public void setLogMessage(@Nullable String logMessage) {
        this.logMessage = logMessage;
    }

    @Generated
    public Gatekeeper<?> getGatekeeper() {
        return this.gatekeeper;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public Section getConfig() {
        return this.config;
    }

    @Generated
    public boolean isLoaded() {
        return this.loaded;
    }

    @Generated
    public int getPriority() {
        return this.priority;
    }

    @Generated
    public Object getKickMessage() {
        return this.kickMessage;
    }

    @Nullable
    @Generated
    public String getLogMessage() {
        return this.logMessage;
    }
}

